/*
 * Copyright 2007-2012 Bull S.A.S.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.ow2.spec.testengine.metadata;

import org.ow2.spec.testengine.SignatureResultSet;

public class InnerClassMetadata extends AbsMetadata {

    private String name = null;

    private String outerName = null;

    private String innerName = null;

    private int access = 0;

    public InnerClassMetadata(String name, String outerName, String innerName, int access) {
        this.name = name;
        this.outerName = outerName;
        this.innerName = innerName;
        this.access = access;
    }

    @Override
    public String toXML(String indent) {
        StringBuilder sb = new StringBuilder();
        //String newIndent = indent + "  ";

        sb.append("\n");
        sb.append(indent);
        sb.append("<inner-class");

        // attributes

        // Name Attribute
        addObjectToSB("name", name, sb);

        // outerName Attribute
        addObjectToSB("outer-name", outerName, sb);

        // innerName Attribute
        addObjectToSB("inner-name", innerName, sb);

        // access Attribute
        addObjectToSB("access", access, sb);

        sb.append(" />");

        return sb.toString();
    }

    @Override
    public int hashCode() {
        return name.hashCode();
    }

    public String getName() {
        return name;
    }

    public void compare(InnerClassMetadata other, SignatureResultSet rs) {
        // compare access
        compare(getName() + " access", access, other.access, rs);

        // compare name
        compare(getName() + " name", name, other.name, rs);

        // compare outer name
        compare(getName() + " outer Name", outerName, other.outerName, rs);

        // compare inner name
        compare(getName() + " inner name", innerName, other.innerName, rs);

    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof InnerClassMetadata)) {
            return false;
        }

        SignatureResultSet rs = new SignatureResultSet();
        try {
            compare((InnerClassMetadata) o, rs);
        } catch (Exception e) {
            return false;
        }
        return !rs.hasErrors();
    }
}
