/*
 * Copyright 2007-2012 Bull S.A.S.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.ow2.spec.testengine.xml;

import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

/**
 * Define an error handler which throw an exception as Digester not (only print
 * stack trace). This handler is use for throwing/catching in a convenient way
 * the xml parsing error of xml file.
 * @author Florent Benoit
 */
public class EasyBeansErrorHandler implements ErrorHandler {

    /**
     * Receive notification of a warning.
     * @param exception exception to throw
     * @throws SAXException if an error is thrown
     */
    public void warning(final SAXParseException exception) throws SAXException {

    }

    /**
     * Receive notification of a recoverable error.
     * @param exception exception to throw
     * @throws SAXException if an error is thrown
     */
    public void error(final SAXParseException exception) throws SAXException {
        throw new SAXException("Parse Fatal Error at line " + exception.getLineNumber() + " column "
                + exception.getColumnNumber() + ": " + exception.getMessage());
    }

    /**
     * Receive notification of a non-recoverable error.
     * @param exception exception to throw
     * @throws SAXException if an error is thrown
     */
    public void fatalError(final SAXParseException exception) throws SAXException {
        throw new SAXException("Parse Fatal Error at line " + exception.getLineNumber() + " column "
                + exception.getColumnNumber() + ": " + exception.getMessage());
    }

}
