/*
 * Copyright 2007-2012 Bull S.A.S.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.ow2.spec.testengine;

import org.objectweb.asm.AnnotationVisitor;
import org.ow2.spec.testengine.metadata.AnnotationMetadata;
import org.ow2.spec.testengine.metadata.EnumAnnotationMetadata;

public class AnalyzerAnnotationVisitor implements AnnotationVisitor {

    private AnnotationMetadata annotationMetadata = null;

    public AnalyzerAnnotationVisitor(AnnotationMetadata annotationMetadata) {
        this.annotationMetadata = annotationMetadata;
    }

    public void visit(String arg0, Object arg1) {

    }

    public AnnotationVisitor visitAnnotation(String arg0, String arg1) {
        return this;
    }

    public AnnotationVisitor visitArray(String arg0) {
        return this;
    }

    public void visitEnd() {

    }

    /**
     * Visits an enumeration value of the annotation.
     *
     * @param name the value name.
     * @param desc the class descriptor of the enumeration class.
     * @param value the actual enumeration value.
     */
    public void visitEnum(String name, String desc, String value) {
        EnumAnnotationMetadata enumAnnotationMetadata = new EnumAnnotationMetadata(name, desc, value);
        annotationMetadata.addEnumAnnotationMetadata(enumAnnotationMetadata);
    }

}
