/*
 * Copyright 2007-2012 Bull S.A.S.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.ow2.spec.testengine.metadata;

import java.util.ArrayList;
import java.util.List;

import org.ow2.spec.testengine.SignatureResultSet;

public class AnnotationMetadata  extends AbsMetadata {

    private String desc = null;

    private boolean visible = false;

    private List<EnumAnnotationMetadata> enumAnnotationMetadataList = null;


    public AnnotationMetadata(String desc, boolean visible) {
        this.desc = desc;
        this.visible = visible;
        this.enumAnnotationMetadataList = new ArrayList<EnumAnnotationMetadata>();
    }

    public void addEnumAnnotationMetadata(EnumAnnotationMetadata enumAnnotationMetadata) {
        enumAnnotationMetadataList.add(enumAnnotationMetadata);
    }

    public String getName() {
        return desc;
    }

    public void compare(AnnotationMetadata other, SignatureResultSet rs) {
        // compare desc
        compare(getName() + " desc", desc, other.desc, rs);

        // compare visible
        compare(getName() + " visible", visible, other.visible, rs);

        // compare enum
        compareList(getName() + " enum", enumAnnotationMetadataList, other.enumAnnotationMetadataList, rs);



    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof AnnotationMetadata)) {
            return false;
        }

        SignatureResultSet rs = new SignatureResultSet();
        try {
            compare((AnnotationMetadata) o, rs);
        } catch (Exception e) {
            return false;
        }
        return !rs.hasErrors();
    }


    @Override
    public String toXML(String indent) {
        StringBuilder sb = new StringBuilder();
        String newIndent = indent + "  ";

        sb.append("\n");
        sb.append(indent);
        sb.append("<annotation");

        // attributes

        // desc Attribute
        addObjectToSB("desc", desc, sb);

        // visible Attribute
        addObjectToSB("visible", visible, sb);


        // enum-annotations
        if (enumAnnotationMetadataList.size()> 0) {
            sb.append(">");

            // exceptions
            addListToSB(enumAnnotationMetadataList, sb, newIndent);

            // end element
            sb.append("\n");
            sb.append(indent);
            sb.append("</annotation>");
        } else {
            // close element directly
            sb.append(" />");

        }

        return sb.toString();
    }

}
