/*
 * Copyright 2007-2012 Bull S.A.S.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.ow2.spec.testengine.metadata;

import org.ow2.spec.testengine.SignatureResultSet;

public class FieldMetadata extends AbsMetadata {

    private int access = 0;

    private String name = null;

    private String desc = null;

    private String signature = null;

    private Object value = null;

    public FieldMetadata(int access, String name, String desc, String signature, Object value) {
        this.access = access;
        this.name = name;
        this.desc = desc;
        this.signature = signature;
        this.value = value;
    }

    public String getName() {
        return name;
    }

    public void compare(FieldMetadata other, SignatureResultSet rs) {
        // compare access
        compare(getName() + " access", access, other.access, rs);

        // compare name
        compare(getName() + " name", name, other.name, rs);

        // compare desc
        compare(getName() + " desc", desc, other.desc, rs);

        // compare signature
        compare(getName() + " signature", signature, other.signature, rs);

        // compare value
        compare(getName() + " value", value, other.value, rs);


    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof FieldMetadata)) {
            return false;
        }

        SignatureResultSet rs = new SignatureResultSet();
        try {
            compare((FieldMetadata) o, rs);
        } catch (Exception e) {
            return false;
        }
        return !rs.hasErrors();
    }

    @Override
    public String toXML(String indent) {
        StringBuilder sb = new StringBuilder();

        sb.append("\n");
        sb.append(indent);
        sb.append("<field");

        // attributes

        // Name Attribute
        addObjectToSB("name", name, sb);

        // desc Attribute
        addObjectToSB("desc", desc, sb);

        // signature Attribute
        addObjectToSB("signature", signature, sb);

        // access Attribute
        addObjectToSB("access", access, sb);

        // value Attribute
        addObjectToSB("value", value, sb);

        // close element
        sb.append(" />");

        return sb.toString();
    }


}
