/*
 * Copyright 2007-2012 Bull S.A.S.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.ow2.spec.testengine;

import java.util.ArrayList;
import java.util.List;

/**
 * Collect all error reports.
 * @author Guillaume Sauthier
 */
public class SignatureResultSet {

    /**
     * The compliance errors.
     */
    List<ComparisonError> errors;

    /**
     * Construct a new {@link SignatureResultSet}.
     */
    public SignatureResultSet() {
        errors = new ArrayList<ComparisonError>();
    }

    /**
     * Add a {@link ComparisonError} in the list.
     * @param error the error to add
     */
    public void addError(ComparisonError error) {
        errors.add(error);
    }

    /**
     * Returns true if this set has errors inside.
     * @return
     */
    public boolean hasErrors() {
        return !errors.isEmpty();
    }

    /* (non-Javadoc)
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();

        int total = errors.size();
        sb.append(total + " errors.");

        int index = 0;
        for (ComparisonError error : errors) {
            sb.append("\n-----------------------------------------------------\n");
            sb.append("Error " + index + " :\n");
            sb.append(error.toString());
            index++;
        }

        return sb.toString();
    }

}
