/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.spec.testengine;

import java.util.ArrayList;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.commons.SerialVersionUIDAdder;
import org.ow2.spec.testengine.AnalyzerClassVisitor;

public class SerialVersionUIDReader
extends SerialVersionUIDAdder {
    private AnalyzerClassVisitor analyzerClassVisitor;

    public SerialVersionUIDReader(AnalyzerClassVisitor analyzerClassVisitor) {
        super((ClassVisitor)analyzerClassVisitor);
        this.analyzerClassVisitor = analyzerClassVisitor;
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.name = name;
        this.computeSVUID = true;
        this.hasSVUID = false;
        this.hasStaticInitializer = false;
        this.svuidFields = new ArrayList();
        this.svuidConstructors = new ArrayList();
        this.svuidMethods = new ArrayList();
        super.visit(version, access, name, signature, superName, interfaces);
        if ("java/lang/Object".equals(superName) && (interfaces == null || interfaces.length == 0)) {
            this.computeSVUID = false;
        }
    }

    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        FieldVisitor fv = super.visitField(access, name, desc, signature, value);
        if (name.equals("serialVersionUID")) {
            this.analyzerClassVisitor.setUID((Long)value);
        }
        return fv;
    }

    public void visitEnd() {
        if (this.computeSVUID) {
            try {
                this.analyzerClassVisitor.setUID(new Long(this.computeSVUID()));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.cv.visitEnd();
    }
}

