/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.spec.testengine;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.ow2.spec.testengine.AnalyzerClassVisitor;
import org.ow2.spec.testengine.SerialVersionUIDReader;
import org.ow2.spec.testengine.metadata.ClassMetadata;

public class SignatureBuiler {
    private JarFile jarFile = null;
    private File outputDir = null;
    private AnalyzerClassVisitor analyzerClassVisitor = null;
    private Map<String, Map<String, ClassMetadata>> packageClassesMetadataMap = null;

    private SignatureBuiler(String[] args) {
        if (args == null) {
            this.usage();
            throw new IllegalArgumentException("No arguments");
        }
        if (args.length < 2) {
            this.usage();
            throw new IllegalArgumentException("Needs at least 2 arguments");
        }
        try {
            this.jarFile = new JarFile(args[0]);
        }
        catch (IOException e) {
            this.usage();
            throw new IllegalArgumentException("The argument '" + args[0] + "' is not a valid JAR file.", e);
        }
        this.outputDir = new File(args[1]);
        if (!this.outputDir.exists()) {
            throw new IllegalArgumentException("No directory found for the path '" + this.outputDir + "'. Create it before.");
        }
        this.packageClassesMetadataMap = new HashMap<String, Map<String, ClassMetadata>>();
        this.analyzerClassVisitor = new AnalyzerClassVisitor(this.packageClassesMetadataMap);
    }

    public void start() throws IOException {
        SerialVersionUIDReader classVisitor = new SerialVersionUIDReader(this.analyzerClassVisitor);
        Enumeration<JarEntry> entries = this.jarFile.entries();
        while (entries.hasMoreElements()) {
            JarEntry jarEntry = entries.nextElement();
            if (!jarEntry.getName().toLowerCase().endsWith(".class")) continue;
            InputStream inputStream = this.jarFile.getInputStream(jarEntry);
            new ClassReader(inputStream).accept((ClassVisitor)classVisitor, 0);
        }
        File outputFile = new File(this.outputDir, "api.xml");
        FileWriter writer = new FileWriter(outputFile);
        writer.write(this.getXML());
        writer.close();
    }

    public String getXML() {
        StringBuilder sb = new StringBuilder();
        String newIndent = "  ";
        sb.append("<analyzer xmlns=\"http://org.ow2.spec/ns/apicheck\">\n");
        Set<String> packages = this.packageClassesMetadataMap.keySet();
        for (String packageName : packages) {
            sb.append(newIndent);
            sb.append("<package name=\"");
            sb.append(packageName);
            sb.append("\">\n");
            Map<String, ClassMetadata> classMetadataMap = this.packageClassesMetadataMap.get(packageName);
            Collection<ClassMetadata> collection = classMetadataMap.values();
            for (ClassMetadata classMetadata : collection) {
                sb.append(classMetadata.toXML(newIndent + "  "));
            }
            sb.append(newIndent);
            sb.append("</package>\n");
        }
        sb.append("</analyzer>");
        return sb.toString();
    }

    public static void main(String[] args) throws IOException {
        SignatureBuiler signatureBuiler = new SignatureBuiler(args);
        signatureBuiler.start();
        System.out.println("result = \n" + signatureBuiler.getXML());
    }

    public void usage() {
        System.out.println("Usage : SignatureBuiler <Jar file to analyze> <output directory>");
        System.out.println("Usage : example : SignatureBuiler /tmp/ejb.jar /tmp/report");
    }
}

