/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.spec.testengine;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.ow2.spec.testengine.AnalyzerClassVisitor;
import org.ow2.spec.testengine.ComparisonError;
import org.ow2.spec.testengine.SerialVersionUIDReader;
import org.ow2.spec.testengine.SignatureResultSet;
import org.ow2.spec.testengine.metadata.AnnotationMetadata;
import org.ow2.spec.testengine.metadata.ClassMetadata;
import org.ow2.spec.testengine.metadata.EnumAnnotationMetadata;
import org.ow2.spec.testengine.metadata.FieldMetadata;
import org.ow2.spec.testengine.metadata.InnerClassMetadata;
import org.ow2.spec.testengine.metadata.MethodMetadata;
import org.ow2.spec.testengine.xml.DocumentParser;
import org.ow2.spec.testengine.xml.DocumentParserException;
import org.ow2.spec.testengine.xml.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SignatureCompare {
    private static final String APICHECK_NS = "http://org.ow2.spec/ns/apicheck";
    private static final String PACKAGE_ELEMENT = "package";
    private static final String CLASS_ELEMENT = "class";
    private static final String INTERFACE_ELEMENT = "interface";
    private static final String METHOD_ELEMENT = "method";
    private static final String ANNOTATION_ELEMENT = "annotation";
    private static final String ENUM_ANNOTATION_ELEMENT = "enum-annotation";
    private static final String FIELD_ELEMENT = "field";
    private static final String INNER_CLASS_ELEMENT = "inner-class";
    private static final String EXCEPTION_ELEMENT = "exception";
    private JarFile jarFile = null;
    private URL urlXML = null;
    private Map<String, Map<String, ClassMetadata>> referencePackageClassesMetadataMap = null;
    private Map<String, Map<String, ClassMetadata>> packageClassesMetadataMap = null;
    private AnalyzerClassVisitor analyzerClassVisitor = null;
    private List<File> allFiles = null;
    private File tmpFile;

    public SignatureCompare(String[] args) {
        if (args == null) {
            this.usage();
            throw new IllegalArgumentException("No arguments");
        }
        if (args.length < 2) {
            this.usage();
            throw new IllegalArgumentException("Needs at least 2 arguments");
        }
        this.tmpFile = new File(args[0]);
        if (!this.tmpFile.exists()) {
            this.usage();
            throw new IllegalArgumentException("The file '" + this.tmpFile.getAbsolutePath() + "' doesn't exists");
        }
        if (this.tmpFile.isDirectory()) {
            this.allFiles = new ArrayList<File>();
            this.addFilesFromDirectory(this.allFiles, this.tmpFile);
        } else {
            try {
                this.jarFile = new JarFile(this.tmpFile);
            }
            catch (IOException e) {
                this.usage();
                throw new IllegalArgumentException("The argument '" + args[0] + "' is not a valid JAR file.", e);
            }
        }
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        this.urlXML = cl.getResource(args[1]);
        if (this.urlXML == null) {
            throw new IllegalArgumentException("Resource '" + args[1] + "' not found in the classloader '" + cl + "'.");
        }
        this.referencePackageClassesMetadataMap = new HashMap<String, Map<String, ClassMetadata>>();
        this.packageClassesMetadataMap = new HashMap<String, Map<String, ClassMetadata>>();
        this.analyzerClassVisitor = new AnalyzerClassVisitor(this.packageClassesMetadataMap);
    }

    public void check() throws IOException {
        SignatureResultSet rs;
        this.readXML(this.urlXML);
        if (this.jarFile != null) {
            this.analyzeJarFile();
        }
        if (this.allFiles != null) {
            this.analyzeDirectory();
        }
        if ((rs = this.compare()).hasErrors()) {
            throw new IOException(rs.toString());
        }
    }

    private void addFilesFromDirectory(List<File> allFiles, File directory) {
        File[] files;
        for (File f : files = directory.listFiles()) {
            if (f.isFile()) {
                allFiles.add(f);
                continue;
            }
            this.addFilesFromDirectory(allFiles, f);
        }
    }

    private void analyzeDirectory() throws IOException {
        SerialVersionUIDReader classVisitor = new SerialVersionUIDReader(this.analyzerClassVisitor);
        for (File f : this.allFiles) {
            if (!f.getName().toLowerCase().endsWith(".class")) continue;
            FileInputStream inputStream = new FileInputStream(f);
            new ClassReader((InputStream)inputStream).accept((ClassVisitor)classVisitor, 0);
            ((InputStream)inputStream).close();
        }
    }

    private void analyzeJarFile() throws IOException {
        SerialVersionUIDReader classVisitor = new SerialVersionUIDReader(this.analyzerClassVisitor);
        Enumeration<JarEntry> entries = this.jarFile.entries();
        while (entries.hasMoreElements()) {
            JarEntry jarEntry = entries.nextElement();
            if (!jarEntry.getName().toLowerCase().endsWith(".class")) continue;
            InputStream inputStream = this.jarFile.getInputStream(jarEntry);
            new ClassReader(inputStream).accept((ClassVisitor)classVisitor, 0);
        }
    }

    private SignatureResultSet compare() {
        SignatureResultSet rs = new SignatureResultSet();
        Set<String> packagesOfFile = this.packageClassesMetadataMap.keySet();
        for (String packageName : packagesOfFile) {
            if (packageName.startsWith("org.ow2")) continue;
            System.out.println("Checking package '" + packageName + "'.");
            Map<String, ClassMetadata> referenceClassMetadataMap = this.referencePackageClassesMetadataMap.get(packageName);
            Map<String, ClassMetadata> analyzedClassMetadataMap = this.packageClassesMetadataMap.get(packageName);
            if (referenceClassMetadataMap == null) {
                referenceClassMetadataMap = new HashMap<String, ClassMetadata>();
            }
            int referenceSize = referenceClassMetadataMap.size();
            int analyzedSite = analyzedClassMetadataMap.size();
            Set<String> referenceClassKeys = referenceClassMetadataMap.keySet();
            for (String className : referenceClassKeys) {
                if (analyzedClassMetadataMap.containsKey(className)) continue;
                rs.addError(new ComparisonError("Missing class '" + className + "' in analyzed jar file '" + this.tmpFile.getName() + "'."));
            }
            Set<String> analyzedClassKeys = analyzedClassMetadataMap.keySet();
            for (String className : analyzedClassKeys) {
                if (referenceClassMetadataMap.containsKey(className)) continue;
                rs.addError(new ComparisonError("The class '" + className + "' is present in the jar file '" + this.tmpFile.getName() + "' but not in the reference."));
            }
            if (referenceSize != analyzedSite) {
                rs.addError(new ComparisonError("Invalid package size"));
            }
            for (String className : referenceClassKeys) {
                ClassMetadata referenceClassMetadata = referenceClassMetadataMap.get(className);
                ClassMetadata analyzedClassMetadata = analyzedClassMetadataMap.get(className);
                if (analyzedClassMetadata == null) {
                    rs.addError(new ComparisonError("'" + className + "' is missing."));
                    continue;
                }
                referenceClassMetadata.compare(analyzedClassMetadata, rs);
            }
        }
        return rs;
    }

    private void readXML(URL url) {
        Document xmlConfigurationDocument = null;
        try {
            xmlConfigurationDocument = DocumentParser.getDocument(url, false, null);
        }
        catch (DocumentParserException e) {
            throw new IllegalArgumentException("Cannot get a document on the given url '" + url + "'.", e);
        }
        Element rootElement = xmlConfigurationDocument.getDocumentElement();
        NodeList packagesList = rootElement.getElementsByTagNameNS(APICHECK_NS, PACKAGE_ELEMENT);
        for (int i = 0; i < packagesList.getLength(); ++i) {
            Element packageElement = (Element)packagesList.item(i);
            String packageName = XMLUtils.getAttributeValue(packageElement, "name");
            Map<String, ClassMetadata> classMetadataMap = this.referencePackageClassesMetadataMap.get(packageName);
            if (classMetadataMap == null) {
                classMetadataMap = new HashMap<String, ClassMetadata>();
                this.referencePackageClassesMetadataMap.put(packageName, classMetadataMap);
            }
            NodeList classesList = packageElement.getElementsByTagNameNS(APICHECK_NS, CLASS_ELEMENT);
            for (int c = 0; c < classesList.getLength(); ++c) {
                Element classElement = (Element)classesList.item(c);
                String className = XMLUtils.getAttributeValue(classElement, "name");
                String classSuperName = XMLUtils.getAttributeValue(classElement, "super-name");
                String classAccess = XMLUtils.getAttributeValue(classElement, "access");
                String classSignature = XMLUtils.getAttributeValue(classElement, "signature");
                String classUid = XMLUtils.getAttributeValue(classElement, "uid");
                String[] interfaces = null;
                NodeList interfacesList = classElement.getElementsByTagNameNS(APICHECK_NS, INTERFACE_ELEMENT);
                if (interfacesList.getLength() > 0) {
                    interfaces = new String[interfacesList.getLength()];
                    for (int j = 0; j < interfacesList.getLength(); ++j) {
                        String interfaceName;
                        Element interfaceElement = (Element)interfacesList.item(j);
                        interfaces[j] = interfaceName = XMLUtils.getAttributeValue(interfaceElement, "name");
                    }
                }
                ClassMetadata classMetadata = new ClassMetadata(Integer.valueOf(classAccess), className, classSignature, classSuperName, interfaces);
                if (classUid != null) {
                    classMetadata.setUID(Long.valueOf(classUid));
                }
                classMetadataMap.put(className, classMetadata);
                NodeList methodsList = classElement.getElementsByTagNameNS(APICHECK_NS, METHOD_ELEMENT);
                for (int m = 0; m < methodsList.getLength(); ++m) {
                    Element methodElement = (Element)methodsList.item(m);
                    String methodName = XMLUtils.getAttributeValue(methodElement, "name");
                    String methodDesc = XMLUtils.getAttributeValue(methodElement, "desc");
                    String methodAccess = XMLUtils.getAttributeValue(methodElement, "access");
                    String methodSignature = XMLUtils.getAttributeValue(methodElement, "signature");
                    String[] methodExceptions = null;
                    NodeList methodExceptionsList = methodElement.getElementsByTagNameNS(APICHECK_NS, EXCEPTION_ELEMENT);
                    if (methodExceptionsList.getLength() > 0) {
                        methodExceptions = new String[methodExceptionsList.getLength()];
                        for (int j = 0; j < methodExceptionsList.getLength(); ++j) {
                            String methodExceptionName;
                            Element methodExceptionElement = (Element)methodExceptionsList.item(j);
                            methodExceptions[j] = methodExceptionName = XMLUtils.getAttributeValue(methodExceptionElement, "name");
                        }
                    }
                    MethodMetadata methodMetadata = new MethodMetadata(Integer.valueOf(methodAccess), methodName, methodDesc, methodSignature, methodExceptions);
                    classMetadata.addMethodMetadata(methodMetadata);
                }
                NodeList fieldsList = classElement.getElementsByTagNameNS(APICHECK_NS, FIELD_ELEMENT);
                for (int f = 0; f < fieldsList.getLength(); ++f) {
                    Element fieldElement = (Element)fieldsList.item(f);
                    String fieldName = XMLUtils.getAttributeValue(fieldElement, "name");
                    String fieldDesc = XMLUtils.getAttributeValue(fieldElement, "desc");
                    String fieldAccess = XMLUtils.getAttributeValue(fieldElement, "access");
                    String fieldValue = XMLUtils.getAttributeValue(fieldElement, "value");
                    String fieldSignature = XMLUtils.getAttributeValue(fieldElement, "signature");
                    FieldMetadata fieldMetadata = new FieldMetadata(Integer.valueOf(fieldAccess), fieldName, fieldDesc, fieldSignature, fieldValue);
                    classMetadata.addFieldMetadata(fieldMetadata);
                }
                NodeList innerClassesList = classElement.getElementsByTagNameNS(APICHECK_NS, INNER_CLASS_ELEMENT);
                for (int k = 0; k < innerClassesList.getLength(); ++k) {
                    Element innerClassElement = (Element)innerClassesList.item(k);
                    String innerClassName = XMLUtils.getAttributeValue(innerClassElement, "name");
                    String innerClassOuterName = XMLUtils.getAttributeValue(innerClassElement, "outer-name");
                    String innerClassInnerName = XMLUtils.getAttributeValue(innerClassElement, "inner-name");
                    String innerClassAccess = XMLUtils.getAttributeValue(innerClassElement, "access");
                    InnerClassMetadata innerClassMetadata = new InnerClassMetadata(innerClassName, innerClassOuterName, innerClassInnerName, Integer.valueOf(innerClassAccess));
                    classMetadata.addInnerClassMetadata(innerClassMetadata);
                }
                NodeList annotationsList = classElement.getElementsByTagNameNS(APICHECK_NS, ANNOTATION_ELEMENT);
                for (int a = 0; a < annotationsList.getLength(); ++a) {
                    Element annotationElement = (Element)annotationsList.item(a);
                    String annotationDesc = XMLUtils.getAttributeValue(annotationElement, "desc");
                    String annotationVisible = XMLUtils.getAttributeValue(annotationElement, "visible");
                    AnnotationMetadata annotationMetadata = new AnnotationMetadata(annotationDesc, Boolean.valueOf(annotationVisible));
                    classMetadata.addAnnotationMetadata(annotationMetadata);
                    NodeList enumAnnotationsList = annotationElement.getElementsByTagNameNS(APICHECK_NS, ENUM_ANNOTATION_ELEMENT);
                    for (int e = 0; e < enumAnnotationsList.getLength(); ++e) {
                        Element enumAnnotationElement = (Element)enumAnnotationsList.item(e);
                        String enumAnnotationName = XMLUtils.getAttributeValue(enumAnnotationElement, "name");
                        String enumAnnotationDesc = XMLUtils.getAttributeValue(enumAnnotationElement, "desc");
                        String enumAnnotationValue = XMLUtils.getAttributeValue(enumAnnotationElement, "value");
                        EnumAnnotationMetadata enumAnnotationMetadata = new EnumAnnotationMetadata(enumAnnotationName, enumAnnotationDesc, enumAnnotationValue);
                        annotationMetadata.addEnumAnnotationMetadata(enumAnnotationMetadata);
                    }
                }
            }
        }
        System.out.println("packages = " + this.referencePackageClassesMetadataMap.keySet());
    }

    public static void main(String[] args) throws IOException {
        String[] newArgs = new String[]{"/home/test/workspace/ow2-spec/ee/ejb-3.0/target/ow2-ejb-3.0-spec.jar", "/tmp/report"};
        SignatureCompare signatureCompare = new SignatureCompare(newArgs);
        signatureCompare.check();
    }

    public void usage() {
        System.out.println("Usage : SignatureCompare <Jar file to check> <input directory>");
        System.out.println("Usage : example : SignatureCompare /tmp/ejb.jar /tmp/data");
    }
}

