/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.spec.testengine.metadata;

import org.ow2.spec.testengine.SignatureResultSet;
import org.ow2.spec.testengine.metadata.AbsMetadata;

public class InnerClassMetadata
extends AbsMetadata {
    private String name = null;
    private String outerName = null;
    private String innerName = null;
    private int access = 0;

    public InnerClassMetadata(String name, String outerName, String innerName, int access) {
        this.name = name;
        this.outerName = outerName;
        this.innerName = innerName;
        this.access = access;
    }

    public String toXML(String indent) {
        StringBuilder sb = new StringBuilder();
        sb.append("\n");
        sb.append(indent);
        sb.append("<inner-class");
        this.addObjectToSB("name", this.name, sb);
        this.addObjectToSB("outer-name", this.outerName, sb);
        this.addObjectToSB("inner-name", this.innerName, sb);
        this.addObjectToSB("access", this.access, sb);
        sb.append(" />");
        return sb.toString();
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String getName() {
        return this.name;
    }

    public void compare(InnerClassMetadata other, SignatureResultSet rs) {
        this.compare(this.getName() + " access", this.access, other.access, rs);
        this.compare(this.getName() + " name", this.name, other.name, rs);
        this.compare(this.getName() + " outer Name", this.outerName, other.outerName, rs);
        this.compare(this.getName() + " inner name", this.innerName, other.innerName, rs);
    }

    public boolean equals(Object o) {
        if (!(o instanceof InnerClassMetadata)) {
            return false;
        }
        SignatureResultSet rs = new SignatureResultSet();
        try {
            this.compare((InnerClassMetadata)o, rs);
        }
        catch (Exception e) {
            return false;
        }
        return !rs.hasErrors();
    }
}

