/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.spec.testengine.metadata;

import org.ow2.spec.testengine.SignatureResultSet;
import org.ow2.spec.testengine.metadata.AbsMetadata;

public class MethodMetadata
extends AbsMetadata {
    private int access;
    private String name;
    private String desc = null;
    private String signature = null;
    private String[] exceptions = null;

    public MethodMetadata(int access, String name, String desc, String signature, String[] exceptions) {
        this.access = access;
        this.name = name;
        this.desc = desc;
        this.signature = signature;
        this.exceptions = exceptions;
    }

    public String getName() {
        return this.name;
    }

    public void compare(MethodMetadata other, SignatureResultSet rs) {
        this.compare(this.getName() + " access", this.access, other.access, rs);
        this.compare(this.getName() + " name", this.name, other.name, rs);
        this.compare(this.getName() + " desc", this.desc, other.desc, rs);
        this.compare(this.getName() + " signature", this.signature, other.signature, rs);
        this.compare(this.getName() + " exceptions", this.exceptions, other.exceptions, rs);
    }

    public boolean equals(Object o) {
        if (!(o instanceof MethodMetadata)) {
            return false;
        }
        SignatureResultSet rs = new SignatureResultSet();
        try {
            this.compare((MethodMetadata)o, rs);
        }
        catch (Exception e) {
            return false;
        }
        return !rs.hasErrors();
    }

    public String toXML(String indent) {
        StringBuilder sb = new StringBuilder();
        String newIndent = indent + "  ";
        sb.append("\n");
        sb.append(indent);
        sb.append("<method");
        this.addObjectToSB("name", this.name, sb);
        this.addObjectToSB("desc", this.desc, sb);
        this.addObjectToSB("signature", this.signature, sb);
        this.addObjectToSB("access", this.access, sb);
        if (this.exceptions != null) {
            sb.append(">");
            this.addArrayObjectToSB("exception", this.exceptions, sb, newIndent);
            sb.append("\n");
            sb.append(indent);
            sb.append("</method>");
        } else {
            sb.append(" />");
        }
        return sb.toString();
    }
}

