/**
 * EasyBeans
 * Copyright (C) 2006 Bull S.A.S.
 * Contact: easybeans@objectweb.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: AnalyzerAnnotationVisitor.java 4359 2008-12-10 10:24:40Z sauthieg $
 * --------------------------------------------------------------------------
 */

package org.ow2.spec.testengine;

import org.objectweb.asm.AnnotationVisitor;
import org.ow2.spec.testengine.metadata.AnnotationMetadata;
import org.ow2.spec.testengine.metadata.EnumAnnotationMetadata;

public class AnalyzerAnnotationVisitor implements AnnotationVisitor {

    private AnnotationMetadata annotationMetadata = null;

    public AnalyzerAnnotationVisitor(AnnotationMetadata annotationMetadata) {
        this.annotationMetadata = annotationMetadata;
    }

    public void visit(String arg0, Object arg1) {

    }

    public AnnotationVisitor visitAnnotation(String arg0, String arg1) {
        return this;
    }

    public AnnotationVisitor visitArray(String arg0) {
        return this;
    }

    public void visitEnd() {

    }

    /**
     * Visits an enumeration value of the annotation.
     *
     * @param name the value name.
     * @param desc the class descriptor of the enumeration class.
     * @param value the actual enumeration value.
     */
    public void visitEnum(String name, String desc, String value) {
        EnumAnnotationMetadata enumAnnotationMetadata = new EnumAnnotationMetadata(name, desc, value);
        annotationMetadata.addEnumAnnotationMetadata(enumAnnotationMetadata);
    }

}
