/**
 * EasyBeans
 * Copyright (C) 2006 Bull S.A.S.
 * Contact: easybeans@objectweb.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: FieldMetadata.java 5276 2010-01-08 16:22:04Z benoitf $
 * --------------------------------------------------------------------------
 */

package org.ow2.spec.testengine.metadata;

import org.ow2.spec.testengine.SignatureResultSet;

public class FieldMetadata extends AbsMetadata {

    private int access = 0;

    private String name = null;

    private String desc = null;

    private String signature = null;

    private Object value = null;

    public FieldMetadata(int access, String name, String desc, String signature, Object value) {
        this.access = access;
        this.name = name;
        this.desc = desc;
        this.signature = signature;
        this.value = value;
    }

    public String getName() {
        return name;
    }

    public void compare(FieldMetadata other, SignatureResultSet rs) {
        // compare access
        compare(getName() + " access", access, other.access, rs);

        // compare name
        compare(getName() + " name", name, other.name, rs);

        // compare desc
        compare(getName() + " desc", desc, other.desc, rs);

        // compare signature
        compare(getName() + " signature", signature, other.signature, rs);

        // compare value
        compare(getName() + " value", value, other.value, rs);


    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof FieldMetadata)) {
            return false;
        }

        SignatureResultSet rs = new SignatureResultSet();
        try {
            compare((FieldMetadata) o, rs);
        } catch (Exception e) {
            return false;
        }
        return !rs.hasErrors();
    }

    @Override
    public String toXML(String indent) {
        StringBuilder sb = new StringBuilder();

        sb.append("\n");
        sb.append(indent);
        sb.append("<field");

        // attributes

        // Name Attribute
        addObjectToSB("name", name, sb);

        // desc Attribute
        addObjectToSB("desc", desc, sb);

        // signature Attribute
        addObjectToSB("signature", signature, sb);

        // access Attribute
        addObjectToSB("access", access, sb);

        // value Attribute
        addObjectToSB("value", value, sb);

        // close element
        sb.append(" />");

        return sb.toString();
    }


}
