/**
 * OW2 Spec
 * Copyright (C) 2010 Bull S.A.S.
 * Contact: easybeans@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: Nonbinding.java 5375 2010-02-25 17:25:09Z sauthieg $
 * --------------------------------------------------------------------------
 */

package javax.enterprise.util;

import java.lang.annotation.Documented;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.Target;

import javax.inject.Scope;

import static java.lang.annotation.ElementType.FIELD;
import static java.lang.annotation.ElementType.METHOD;
import static java.lang.annotation.ElementType.TYPE;
import static java.lang.annotation.RetentionPolicy.RUNTIME;

/**
 * Excludes a member of an annotation type (such as a qualifier type or interceptor binding
 * type) from consideration when the container compares two annotation instances.
 *
 * <pre>
 *  &#064;Qualifier
 *  &#064;Retention(RUNTIME)
 *  &#064;Target({METHOD, FIELD, PARAMETER, TYPE})
 *  public @interface PayBy {
 *    PaymentMethod value();
 *    &#064;Nonbinding String comment();
 *  }
 * </pre>
 *
 * @author Guillaume Sauthier
 *
 * @since CDI 1.0
 * @see javax.inject.Qualifier
 * @see javax.interceptor.InterceptorBinding
 */
@Target(METHOD)
@Retention(RUNTIME)
public @interface Nonbinding {}