/**
 * OW2 Specifications
 * Copyright (C) 2007 Bull S.A.S.
 * Contact: easybeans@objectweb.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: InvalidPropertyException.java 4359 2008-12-10 10:24:40Z sauthieg $
 * --------------------------------------------------------------------------
 */

package javax.resource.spi;

import java.beans.PropertyDescriptor;

import javax.resource.ResourceException;
 
/**
 * This exception is thrown to indicate invalid configuration property settings.
 * @version 0.2
 * @author Guillaume Sauthier
 */
public class InvalidPropertyException extends ResourceException {

    /**
     * Serial version UID.
     */
    private static final long serialVersionUID = -485903720300735741L;
    
    /**
     * Invalid JavaBean {@link PropertyDescriptor}s.
     */
    private PropertyDescriptor[] invalidPropertyDescriptors;

    /**
     * Create a InvalidPropertyException.
     */
    public InvalidPropertyException() {
        super();
    }

    /**
     * Constructs a new throwable with the specified detail message and
     * an error code.
     * @param message a description of the exception.
     * @param errorCode a string specifying the vendor specific error code.
     */
    public InvalidPropertyException(String message, String errorCode) {
        super(message, errorCode);
    }

    /**
     * Constructs a new throwable with the specified detail message and cause.
     * @param message the detail message.
     * @param cause a chained exception of type Throwable.
     */
    public InvalidPropertyException(String message, Throwable cause) {
        super(message, cause);
    }

    /**
     * Create a InvalidPropertyException.
     * @param message a description of the exception
     */
    public InvalidPropertyException(String message) {
        super(message);
    }

    /**
     * Constructs a new throwable with the specified cause.
     * @param cause a chained exception of type Throwable.
     */
    public InvalidPropertyException(Throwable cause) {
        super(cause);
    }

    /**
     * Set a list of invalid properties.
     */
    public void setInvalidPropertyDescriptors(PropertyDescriptor[] invalidProperties) {
        this.invalidPropertyDescriptors = invalidProperties;
    }
    
    /**
     * Get the list of invalid properties.
     */
    public PropertyDescriptor[] getInvalidPropertyDescriptors() {
        return invalidPropertyDescriptors;
    }
}
