/**
 * OW2 Specifications
 * Copyright (C) 2007 Bull S.A.S.
 * Contact: easybeans@objectweb.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: ConnectionMetaData.java 6201 2012-03-21 10:28:10Z benoitf $
 * --------------------------------------------------------------------------
 */

package javax.resource.cci;

import javax.resource.ResourceException;

/**
 * The interface ConnectionMetaData provides information about an
 * EIS instance connected through a Connection instance. A component
 * calls the method Connection.getMetaData to get a ConnectionMetaData
 * instance.
 * @author Guillaume Sauthier
 */
public interface ConnectionMetaData {

    /**
     * Returns product name of the underlying EIS instance connected
     * through the Connection that produced this metadata.
     * @return Product name of the EIS instance
     * @throws ResourceException Failed to get the information for the
     *         EIS instance
     */
    String getEISProductName() throws ResourceException;

    /**
     * Returns product version of the underlying EIS instance.
     * @return Product version of an EIS instance.
     * @throws ResourceException Failed to get the information for the
     *         EIS instance
     */
    String getEISProductVersion() throws ResourceException;

    /**
     * Returns the user name for an active connection as known to the
     * underlying EIS instance. The name corresponds the resource
     * principal under whose security context a connection to the EIS
     * instance has been established.
     * @return String representing the user name
     * @throws ResourceException Failed to get the information for the
     *         EIS instance
     */
    String getUserName() throws ResourceException;
}
