/**
 * OW2 Specifications
 * Copyright (C) 2012 Bull S.A.S.
 * Contact: easybeans@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: Activation.java 6201 2012-03-21 10:28:10Z benoitf $
 * --------------------------------------------------------------------------
 */

package javax.resource.spi;

import static java.lang.annotation.ElementType.TYPE;
import static java.lang.annotation.RetentionPolicy.RUNTIME;

import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.Target;

/**
 * Designates a JavaBean as an ActivationSpec. This annotation may be placed on a JavaBean. A JavaBean annotated with the
 * Activation annotation is not required to implement the ActivationSpec interface. <br />
 * The ActivationSpec JavaBean contains the configuration information pertaining to inbound connectivity from an EIS instance. A
 * resource adapter capable of message delivery to message endpoints must provide an JavaBean class implementing the
 * ActivationSpec interface or annotate a JavaBean with the Activation annotation for each supported endpoint message listener
 * type. <br />
 * The ActivationSpec JavaBean has a set of configurable properties specific to the messaging style and the message provider. <br />
 * Together with the messageListener annotation element, this annotation specifies information about a specific message listener
 * type supported by the messaging resource adapter.
 * @since 1.6
 * @author Florent Benoit
 */
@Documented
@Target(TYPE)
@Retention(RUNTIME)
public @interface Activation {

    /**
     * Indicates the message listener type(s) associated with this activation.
     * @return The Java types of the Message Listener interface this activation-spec is associated with.
     */
    Class[] messageListeners();
}
