/**
 * OW2 Specifications
 * Copyright (C) 2012 Bull S.A.S.
 * Contact: easybeans@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: Connector.java 6201 2012-03-21 10:28:10Z benoitf $
 * --------------------------------------------------------------------------
 */

package javax.resource.spi;

import static java.lang.annotation.ElementType.TYPE;
import static java.lang.annotation.RetentionPolicy.RUNTIME;

import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.Target;

import javax.resource.spi.TransactionSupport.TransactionSupportLevel;
import javax.resource.spi.work.WorkContext;

/**
 * The Connector annotation is a component-defining annotation and it can be used by the resource adapter developer to specify
 * that the JavaBean is a resource adapter JavaBean. The Connector annotation is applied to the JavaBean class.
 * @since 1.6
 * @author Florent Benoit
 */
@Documented
@Target(TYPE)
@Retention(RUNTIME)
public @interface Connector {

    /**
     * Describes the resource adapter module.
     */
    String[] description() default {};

    /**
     * An optional short name, providing information about the resource adapter module, that is intended to be displayed by tools.
     */
    String[] displayName() default {};

    /**
     * Specifies the file name for small GIF or JPEG icon images that are used to represent the resource adapter in a GUI tool.
     * Each smallIcon must be associated with a largeIcon element and the application server must use the ordinal value in their
     * respective arrays to find the related pairs of icons.
     */
    String[] smallIcon() default {};

    /**
     * Specifies the file name for large GIF or JPEG icon images that are used to represent the resource adapter in a GUI tool.
     * Each smallIcon must be associated with a largeIcon element and the application server must use the ordinal value in their
     * respective arrays to find the related pairs of icons.
     */
    String[] largeIcon() default {};

    /**
     * Specifies the name of the resource adapter provider vendor.
     */
    String vendorName() default "";

    /**
     * Contains information about the type of EIS. For example, the type of an EIS can be product name of the EIS independent of
     * any version info.This helps in identifying EIS instances that can be used with this resource adapter.
     */
    String eisType() default "";

    /**
     * Specifies the version of the resource adapter implementation.
     */
    String version() default "";

    /**
     * Specifies licensing requirements for the resource adapter module and an optional description of the licensing terms .
     */
    String[] licenseDescription() default {};

    /**
     * Specifies whether a license is required to deploy and use this resource adapter.
     */
    boolean licenseRequired() default false;

    /**
     * Specifies the authentication mechanisms supported by the resource adapter.
     */
    AuthenticationMechanism[] authMechanisms() default {};

    /**
     * Specifies whether a license is required to deploy and use this resource adapter.
     */
    boolean reauthenticationSupport() default false;

    /**
     * Specifies the extended security permissions required to be provided for the operation of the resource adapter module.
     */
    SecurityPermission[] securityPermissions() default {};

    /**
     * Specifies the level of transaction support provided by the resource adapter.
     */
    TransactionSupportLevel transactionSupport() default TransactionSupportLevel.NoTransaction;

    /**
     * Specifies a list of fully qualified classes that implements the WorkContext interface that a resource adapter requires the
     * application server to support.
     */
    Class<? extends WorkContext>[] requiredWorkContexts() default {};

}
