/**
 * OW2 Specifications
 * Copyright (C) 2007 Bull S.A.S.
 * Contact: easybeans@objectweb.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: ManagedConnectionMetaData.java 6201 2012-03-21 10:28:10Z benoitf $
 * --------------------------------------------------------------------------
 */

package javax.resource.spi;

import javax.resource.ResourceException;
 
/**
 * The ManagedConnectionMetData interface provides information about the
 * underlying EIS instance associated with a ManagedConnection instance.
 * An application server uses this information to get runtime information
 * about a connected EIS instance.<br/>
 * 
 * The method ManagedConnection.getMetaData returns a ManagedConnectionMetaData
 * instance.
 * @version 0.8
 * @author Guillaume Sauthier
 */
public interface ManagedConnectionMetaData {

    /**
     * Returns Product name of the underlying EIS instance connected through
     * the ManagedConnection.
     * @return Product name of the EIS instance.
     * @throws ResourceException
     */
    String getEISProductName() throws ResourceException;
    
    /**
     * Returns product version of the underlying EIS instance connected through
     * the ManagedConnection.
     * @return Product version of the EIS instance
     * @throws ResourceException
     */
    String getEISProductVersion() throws ResourceException;
    
    /**
     * Returns maximum limit on number of active concurrent connections that
     * an EIS instance can support across client processes. If an EIS instance
     * does not know about (or does not have) any such limit, it returns a 0.
     * @return Maximum limit for number of active concurrent connections
     * @throws ResourceException
     */
    int getMaxConnections() throws ResourceException;
    
    /**
     * Returns name of the user associated with the ManagedConnection instance.
     * The name corresponds to the resource principal under whose whose security
     * context, a connection to the EIS instance has been established.
     * @return name of the user
     * @throws ResourceException
     */
    String getUserName() throws ResourceException;
}
