/**
 * OW2 Specifications
 * Copyright (C) 2007 Bull S.A.S.
 * Contact: easybeans@objectweb.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: ResourceAdapterInternalException.java 6201 2012-03-21 10:28:10Z benoitf $
 * --------------------------------------------------------------------------
 */

package javax.resource.spi;

import javax.resource.ResourceException;
 
/**
 * A ResourceAdapterInternalException indicates any system-level error
 * conditions related to a resource adapter. The common conditions
 * indicated by this exception type are:<br/>
 * <ul>
 *   <li>Invalid configuration for creation of a new physical
 *   connection. An example is invalid server name for a target EIS
 *   instance.</li>
 *   <li>Failure to create a physical connection to a EIS instance
 *   due to communication protocol error or any resource adapter
 *   implementation specific error.</li>
 *   <li>Error conditions internal to resource adapter implementation.</li>
 * <ul>
 * @version 1.0 
 * @author Guillaume Sauthier
 */
public class ResourceAdapterInternalException extends ResourceException {

    /**
     * Serial version UID.
     */
    private static final long serialVersionUID = -1666678251804763325L;

    /**
     * Constructs a new instance with null as its detail message.
     */
    public ResourceAdapterInternalException() {
        super();
    }

    /**
     * Constructs a new instance with the specified detail message.
     * @param message the detail message.
     */
    public ResourceAdapterInternalException(String message) {
        super(message);
    }

    /**
     * Constructs a new throwable with the specified cause.
     * @param cause a chained exception of type Throwable.
     */
    public ResourceAdapterInternalException(Throwable cause) {
        super(cause);
    }

    /**
     * Constructs a new throwable with the specified detail message and cause.
     * @param message the detail message.
     * @param cause a chained exception of type Throwable.
     */
    public ResourceAdapterInternalException(String message, Throwable cause) {
        super(message, cause);
    }

    /**
     * Constructs a new {@link Throwable} with the specified detail message and
     * an error code.
     * @param message a description of the exception.
     * @param errorCode a string specifying the vendor specific error code.
     */
    public ResourceAdapterInternalException(String message, String errorCode) {
        super(message, errorCode);
    }

}
