/**
 * OW2 Specifications
 * Copyright (C) 2012 Bull S.A.S.
 * Contact: easybeans@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: SecurityPermission.java 6201 2012-03-21 10:28:10Z benoitf $
 * --------------------------------------------------------------------------
 */

package javax.resource.spi;

import static java.lang.annotation.RetentionPolicy.RUNTIME;

import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.Target;

/**
 * The SecurityPermission annotation can be used by the developer, as part of the Connector annotation, to specify the extended security permissions required by the resource adapter 
 * @since 1.6
 * @author Florent Benoit
 */
@Documented
@Target({})
@Retention(RUNTIME)
public @interface SecurityPermission {

    /**
     * Specifies an optional description to mention any specific reason that a resource requires a given security permission. 
     */
    String[] description() default {};

    /**
     * Specifies a security permission based on the Security policy file syntax. These security permissions are different from those required by the default permission set as specified in the connector specification. 
     */
    String permissionSpec() default "";


}
