/**
 * OW2 Specifications
 * Copyright (C) 2012 Bull S.A.S.
 * Contact: easybeans@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: DistributableWorkManager.java 6201 2012-03-21 10:28:10Z benoitf $
 * --------------------------------------------------------------------------
 */

package javax.resource.spi.work;

/**
 * This interface models a WorkManager that supports distributed execution of Work instances.
 * <br />
 * A DistributableWorkManager may choose to distribute a Work instance submitted by a resource adapter to another WorkManager
 * instance running in a different Java virtual machine (that is running in the same host or different hosts) for achieving
 * optimal resource utilization or for providing better response times.
 * <br />
 * A WorkManager implementation that supports the submission of DistributableWork instances must implement the
 * DistributableWorkManager marker interface.
 * @since 1.6
 * @author Florent Benoit
 */
public interface DistributableWorkManager extends WorkManager {


}
