/**
 * OW2 Specifications
 * Copyright (C) 2012 Bull S.A.S.
 * Contact: easybeans@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: RetryableWorkRejectedException.java 6201 2012-03-21 10:28:10Z benoitf $
 * --------------------------------------------------------------------------
 */

package javax.resource.spi.work;

import javax.resource.spi.RetryableException;

/**
 * A subclass of the WorkRejectedException that indicates that the the service unavailability is transient. It is thrown in
 * situations where the previously failed operation might be able to succeed if the resource adapter performs some recovery steps
 * and retries the operation.
 * @since 1.6
 * @author Florent Benoit
 */
public class RetryableWorkRejectedException extends WorkRejectedException implements RetryableException {

    /**
     * Serial version UID.
     */
    private static final long serialVersionUID = 8198870267352154108L;

    /**
     * Constructs a new instance with null as its detail message.
     */
    public RetryableWorkRejectedException() {
        super();
    }

    /**
     * Constructs a new instance with the specified detail message.
     * @param message the detail message.
     */
    public RetryableWorkRejectedException(String message) {
        super(message);
    }

    /**
     * Constructs a new throwable with the specified cause.
     * @param cause a chained exception of type Throwable.
     */
    public RetryableWorkRejectedException(Throwable cause) {
        super(cause);
    }

    /**
     * Constructs a new throwable with the specified detail message and cause.
     * @param message the detail message.
     * @param cause a chained exception of type Throwable.
     */
    public RetryableWorkRejectedException(String message, Throwable cause) {
        super(message, cause);
    }

    /**
     * Constructs a new {@link Throwable} with the specified detail message and an error code.
     * @param message a description of the exception.
     * @param errorCode a string specifying the vendor specific error code.
     */
    public RetryableWorkRejectedException(String message, String errorCode) {
        super(message, errorCode);
    }

}
