/**
 * OW2 Specifications
 * Copyright (C) 2007 Bull S.A.S.
 * Contact: easybeans@objectweb.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: Work.java 6201 2012-03-21 10:28:10Z benoitf $
 * --------------------------------------------------------------------------
 */

package javax.resource.spi.work;
 
/**
 * This models a {@link Work} instance that would be executed by a
 * {@link WorkManager} upon submission.
 * @version 1.0
 * @author Guillaume Sauthier
 */
public interface Work extends Runnable {

    /**
     * The {@link WorkManager} might call this method to hint the
     * active {@link Work} instance to complete execution as soon
     * as possible. This would be called on a seperate thread other
     * than the one currently executing the {@link Work} instance.
     */
    void release();
}
