/**
 * OW2 Specifications
 * Copyright (C) 2012 Bull S.A.S.
 * Contact: easybeans@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: WorkContext.java 6201 2012-03-21 10:28:10Z benoitf $
 * --------------------------------------------------------------------------
 */

package javax.resource.spi.work;

/**
 * This class serves as a standard mechanism for a resource adapter to propagate an imported context from an enterprise
 * information system to an application server. <br />
 * A Work instance, that implements the WorkContextProvider, could provide a List of these WorkContext instances (through the
 * getWorkContexts() method), and have them setup as the execution context by the WorkManager when the Work instance gets
 * executed. The resource adapter must not make any changes to the state of the WorkContext after the Work instance corresponding
 * to that WorkContext has been submitted to the WorkManager.
 * @since 1.6
 * @author Florent Benoit
 */
public interface WorkContext extends java.io.Serializable {

    /**
     * Get the associated name of the WorkContext. This could be used by the WorkManager and the resource adapter for debugging
     * purposes.
     */
    String getName();

    /**
     * Get the brief description of the role played by the WorkContext and any other related debugging information. This could be
     * used by the WorkManager and the resource adapter for debugging purposes.
     * @return the associated description of the WorkContext
     */
    String getDescription();

}
