/**
 * OW2 Specifications
 * Copyright (C) 2012 Bull S.A.S.
 * Contact: easybeans@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: WorkContextLifecycleListener.java 6201 2012-03-21 10:28:10Z benoitf $
 * --------------------------------------------------------------------------
 */

package javax.resource.spi.work;

/**
 * This class models the various events that occur during the processing of the WorkContexts associated with a Work instance. This
 * interface may be implemented by a WorkContext instance to receive notifications from the WorkManager when the WorkContext is
 * set as the execution context of the Work instance it is associated with. <br />
 * When a WorkManager sets up the execution context of a Work instance that implements WorkContextProvider, the WorkManager must
 * make the relevant lifecycle notifications if an WorkContext instance implements this interface. <br />
 * When a Work instance is submitted to the Connector WorkManager using one of the methods that passes in a WorkListener as a
 * parameter, the WorkManager must send Work related notifications to the WorkListener and WorkContext setup related notifications
 * to this interface. <br />
 * The possible error conditions that might occur during associating an WorkContext with a Work instance is captured in
 * WorkContextErrorCodes.
 * @since 1.6
 * @author Florent Benoit
 */
public interface WorkContextLifecycleListener {

    /**
     * Invoked when the WorkContext instance was successfully set as the execution context for the Work instance.
     */
    void contextSetupComplete();

    /**
     * Invoked when the WorkContext instance was set as the execution context for the Work instance it was associated with.
     * @param errorCode One of the error-codes defined in or subclasses of WorkContextErrorCodes
     */
    void contextSetupFailed(String errorCode);
}
