/**
 * OW2 Specifications
 * Copyright (C) 2007 Bull S.A.S.
 * Contact: easybeans@objectweb.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: WorkException.java 6201 2012-03-21 10:28:10Z benoitf $
 * --------------------------------------------------------------------------
 */

package javax.resource.spi.work;

import javax.resource.ResourceException;

/**
 * A common base class for all Work processing related exceptions.
 * @version 1.0
 * @author Guillaume Sauthier
 */
public class WorkException extends ResourceException {
 
    /**
     * Serial version UID.
     */
    private static final long serialVersionUID = 6360106395593829940L;

    /**
     * Indicates an internal error condition.
     */
    public static final String INTERNAL = "-1";
    
    /**
     * Undefined error code.
     */
    public static final String UNDEFINED = "0";
    
    /**
     * Indicates start timeout expiration.
     */
    public static final String START_TIMED_OUT = "1";
    
    /**
     * Indicates that concurrent work within a transaction is
     * disallowed. That is, there is already another Work
     * instance associated with the specified transaction context.
     */
    public static final String TX_CONCURRENT_WORK_DISALLOWED = "2";
    
    /**
     * Indicates a failure in recreating the specified transaction context.
     */
    public static final String TX_RECREATE_FAILED = "3";
    
    /**
     * Constructs a new instance with null as its detail message.
     */
    public WorkException() {
        super();
    }

    /**
     * Constructs a new instance with the specified detail message.
     * @param message the detail message.
     */
    public WorkException(String message) {
        super(message);
    }

    /**
     * Constructs a new throwable with the specified cause.
     * @param cause a chained exception of type Throwable.
     */
    public WorkException(Throwable cause) {
        super(cause);
    }

    /**
     * Constructs a new throwable with the specified detail message and cause.
     * @param message the detail message.
     * @param cause a chained exception of type Throwable.
     */
    public WorkException(String message, Throwable cause) {
        super(message, cause);
    }

    /**
     * Constructs a new {@link Throwable} with the specified detail message and
     * an error code.
     * @param message a description of the exception.
     * @param errorCode a string specifying the vendor specific error code.
     */
    public WorkException(String message, String errorCode) {
        super(message, errorCode);
    }

}
