/**
 * OW2 Specifications
 * Copyright (C) 2007 Bull S.A.S.
 * Contact: easybeans@objectweb.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: WorkListener.java 6201 2012-03-21 10:28:10Z benoitf $
 * --------------------------------------------------------------------------
 */

package javax.resource.spi.work;

import java.util.EventListener;
 
/**
 * This models a WorkListener instance which would be notified by
 * the WorkManager when the various Work processing events (work
 * accepted, work rejected, work started, work completed) occur.
 * The WorkListener instance must not make any thread assumptions
 * and must be thread-safe ie., a notification could occur from any
 * arbitrary thread. Further, it must not make any assumptions on
 * the ordering of notifications.
 * @version 1.0
 * @author Guillaume Sauthier
 */
public interface WorkListener extends EventListener {

    /**
     * Invoked when a Work instance has been accepted.
     * @param e WorkEvent
     */
    void workAccepted(WorkEvent e);
    
    /**
     * Invoked when a Work instance has been rejected.
     * @param e WorkEvent
     */
    void workRejected(WorkEvent e);
    
    /**
     * Invoked when a Work instance has started execution. This only
     * means that a thread has been allocated.
     * @param e WorkEvent
     */
    void workStarted(WorkEvent e);
    
    /**
     * Invoked when a Work instance has completed execution.
     * @param e WorkEvent
     */
    void workCompleted(WorkEvent e);
}
