/**
 * EasyBeans
 * Copyright (C) 2009 Bull S.A.S.
 * Contact: easybeans@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: AsyncResult.java 6008 2011-10-17 13:41:22Z benoitf $
 * --------------------------------------------------------------------------
 */

package javax.ejb;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

/**
 * Wraps the result of an asynchronous method call as a Future object preserving compatability with the business interface
 * signature. The value specified in the constructor will be retrieved by the container and made available to the client. Note
 * that this object is not passed to the client. It is merely a convenience for providing the result value to the container.
 * Therefore, none of its methods should be called by the application.
 * @see <a href="http://www.jcp.org/en/jsr/detail?id=318">EJB 3.1 specification</a>
 * @author Florent Benoit
 * @since EJB 3.1 version.
 */
public final class AsyncResult<V> implements Future<V> {

    /**
     * UID for serialization.
     */
    private static final long serialVersionUID = -2987692932622816868L;
    
    /**
     * Result.
     */
    private final V result;

    /**
     * Construct an AsyncResult for a method's result value.
     * @param result
     */
    public AsyncResult(V result) {
        this.result = result;
    }

    /**
     * This method should not be called.
     */
    public boolean cancel(boolean mayInterruptIfRunning) {
        throw new IllegalStateException("Should not be called");
    }

    /**
     * This method should not be called.
     */
    public V get()  throws InterruptedException, ExecutionException {
        return result;
    }

    /**
     * This method should not be called.
     */
    public V get(long timeout, TimeUnit unit)throws InterruptedException, ExecutionException, TimeoutException {
        throw new IllegalStateException("Should not be called");
    }

    /**
     * This method should not be called.
     */
    public boolean isCancelled() {
        throw new IllegalStateException("Should not be called");
    }

    /**
     * This method should not be called.
     */
    public boolean isDone() {
        throw new IllegalStateException("Should not be called");
    }
}
