/**
 * EasyBeans
 * Copyright (C) 2009-2011 Bull S.A.S.
 * Contact: easybeans@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: TimerConfig.java 6277 2012-08-01 12:40:23Z benoitf $
 * --------------------------------------------------------------------------
 */

package javax.ejb;

import java.io.Serializable;

/**
 * The Timer interface contains information about a timer that was created through the EJB Timer Service.
 * @see <a href="http://www.jcp.org/en/jsr/detail?id=318">EJB 3.1 specification</a>
 * @author Florent Benoit
 * @since EJB 3.1 version.
 */
public class TimerConfig {

    /**
     * Info field.
     */
    private Serializable info;

    /**
     * Is it persistent ?. Default is true !
     */
    private boolean isPersistent = true;

    /**
     * Default constructor.
     */
    public TimerConfig() {
        
    }
    
    /**
     * Constructor with a given serializable info and persistent object.
     * @param info the given info object
     * @param persistent true or false
     */
    public TimerConfig(Serializable info, boolean isPersistent) {
        this.info = info;
       this.isPersistent = isPersistent;
    }
    
    public Serializable getInfo() {
        return info;
    }

    public boolean isPersistent() {
        return isPersistent;
    }

    public void setInfo(Serializable info) {
        this.info = info;
    }

    public void setPersistent(boolean isPersistent) {
        this.isPersistent = isPersistent;
    }
    
    public String toString() {
        StringBuilder sb = new StringBuilder(TimerConfig.class.getSimpleName());
        sb.append("[info=");
        sb.append(info);
        sb.append(",isPersistent=");
        sb.append(isPersistent);
        sb.append("]");
        return sb.toString();
    }

}
