/**
 * EasyBeans
 * Copyright (C) 2009 Bull S.A.S.
 * Contact: easybeans@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: AroundTimeout.java 5417 2010-03-24 09:04:14Z benoitf $
 * --------------------------------------------------------------------------
 */

package javax.interceptor;

import static java.lang.annotation.ElementType.METHOD;
import static java.lang.annotation.RetentionPolicy.RUNTIME;

import java.lang.annotation.Retention;
import java.lang.annotation.Target;

/**
 * Defines an interceptor method that interposes on timeout methods. May be applied to any
 * non-final, non-static method with a single parameter of type {@link InvocationContext} and
 * return type {@code Object} of the target class (or superclass) or of any interceptor class.
 * <pre>
 *  &#064;AroundTimeout
 *  public Object interceptTimeout(InvocationContext ctx) throws Exception { ... }
 * </pre>
 * 
 * <p>A class may not declare more than one {@code @AroundTimeout} method.</p>
 * 
 * <p>An {@code @AroundTimeout} method can invoke any component or resource that its corresponding
 * timeout method can invoke.</p>
 * 
 * <p>{@link InvocationContext#getTimer()} allows any {@code @AroundTimeout} method to retrieve
 * the timer object associated with the timeout.</p>
 * 
 * <p>{@code @AroundTimeout} method invocations occur within the same transaction and security
 * context as the timeout method on which they are interposing.</p>
 * 
 * <p>{@code @AroundTimeout} methods may throw any exceptions that are allowed by the throws
 * clause of the timeout method on which they are interposing. They may catch and suppress
 * exceptions and recover by calling {@link InvocationContext#proceed()}.</p>
 * 
 * @see <a href="http://www.jcp.org/en/jsr/detail?id=318">EJB 3.1 specification</a>
 * @author Florent Benoit
 * @since EJB 3.1 / Interceptor 1.1 version.
 */
@Target(METHOD) @Retention(RUNTIME)
public @interface AroundTimeout {}

