/**
 * EasyBeans
 * Copyright (C) 2010 Bull S.A.S.
 * Contact: easybeans@objectweb.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: CertStoreCallback.java 6201 2012-03-21 10:28:10Z benoitf $
 * --------------------------------------------------------------------------
 */
package javax.security.auth.message.callback;

import java.security.cert.CertStore;

/**
 * Callback for CertStore.
 *
 * <p />
 *
 * A CertStore is a generic repository for certificates.
 * CertStores may be searched to locate public key certificates,
 * as well as to put together certificate chains.
 * Such a search may be necessary when the caller needs to
 * verify a signature.
 *
 * @version 1.0
 */
public class CertStoreCallback implements javax.security.auth.callback.Callback {
    private static final long serialVersionUID = 6830988818735581645L;

    /**
     * The certificate store, SET by the callback handler.
     */
    private CertStore theCertStore;


    /**
     * Create a CertStoreCallback.
     */
    public CertStoreCallback() {
    }

    /**
     * Used by the CallbackHandler to set the CertStore within the Callback.
     *
     * @param certStore The certificate store, which may be null
     */
    public void setCertStore(CertStore certStore) {
	this.theCertStore = certStore;
    }

    /**
     * Used by the CertStore user to obtain the CertStore set within the
     * Callback.
     *
     * @return The CertStore, or null.
     */
    public CertStore getCertStore() {
	return this.theCertStore;
    }

}
