/**
 * OW2 Specifications
 * Copyright (C) 2008 Bull S.A.S.
 * Contact: easybeans@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: MTOMFeature.java 5417 2010-03-24 09:04:14Z benoitf $
 * --------------------------------------------------------------------------
 */

package javax.xml.ws.soap;

import javax.xml.ws.WebServiceFeature;

/**
 * Created by IntelliJ IDEA.
 * User: Guillaume
 * Date: 10 dc. 2008
 * Time: 19:47:20
 * To change this template use File | Settings | File Templates.
 */
public final class MTOMFeature extends WebServiceFeature {

    public static final String ID = "http://www.w3.org/2004/08/soap/features/http-optimization";

    protected int threshold;

    public MTOMFeature() {
        this.enabled = true;
    }

    public MTOMFeature(boolean enabled) {
        this.enabled = enabled;
    }

    public MTOMFeature(int threshold) {
        this.enabled = true;
        this.threshold = threshold;
    }

    public MTOMFeature(boolean enabled,
                   int threshold) {
        this.enabled = enabled;
        this.threshold = threshold;
    }

    public String getID() {
        return ID;
    }

    public int getThreshold() {
        return threshold;
    }
}
