/**
 * OW2 Specifications
 * Copyright (C) 2008 Bull S.A.S.
 * Contact: easybeans@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: ServiceDelegate.java 5417 2010-03-24 09:04:14Z benoitf $
 * --------------------------------------------------------------------------
 */

package javax.xml.ws.spi;

import javax.xml.bind.JAXBContext;
import javax.xml.namespace.QName;
import javax.xml.ws.Dispatch;
import javax.xml.ws.EndpointReference;
import javax.xml.ws.Service;
import javax.xml.ws.WebServiceFeature;
import javax.xml.ws.handler.HandlerResolver;
import java.net.URL;
import java.util.Iterator;
import java.util.concurrent.Executor;

/**
 * Created by IntelliJ IDEA.
 * User: Guillaume
 * Date: 9 dc. 2008
 * Time: 20:29:41
 * To change this template use File | Settings | File Templates.
 */
public abstract class ServiceDelegate {

    protected ServiceDelegate() {}

    public abstract <T> T getPort(QName portName,
                                  Class<T> serviceEndpointInterface);

    public abstract <T> T getPort(javax.xml.namespace.QName portName,
                              java.lang.Class<T> serviceEndpointInterface,
                              WebServiceFeature... features);

    public abstract <T> T getPort(EndpointReference endpointReference,
                              java.lang.Class<T> serviceEndpointInterface,
                              WebServiceFeature... features);

    public abstract <T> T getPort(Class<T> serviceEndpointInterface);

    public abstract <T> T getPort(java.lang.Class<T> serviceEndpointInterface,
                              WebServiceFeature... features);

    public abstract void addPort(QName portName,
                             String bindingId,
                             String endpointAddress);

    public abstract <T> Dispatch<T> createDispatch(QName portName,
                                               Class<T> type,
                                               Service.Mode mode);

    public abstract Dispatch<Object> createDispatch(QName portName,
                                                JAXBContext context,
                                                Service.Mode mode);

    public abstract <T> Dispatch<T> createDispatch(javax.xml.namespace.QName portName,
                                               java.lang.Class<T> type,
                                               Service.Mode mode,
                                               WebServiceFeature... features);

    public abstract <T> Dispatch<T> createDispatch(EndpointReference endpointReference,
                                               java.lang.Class<T> type,
                                               Service.Mode mode,
                                               WebServiceFeature... features);

    public abstract Dispatch<java.lang.Object> createDispatch(javax.xml.namespace.QName portName,
                                                          javax.xml.bind.JAXBContext context,
                                                          Service.Mode mode,
                                                          WebServiceFeature... features);

    public abstract Dispatch<java.lang.Object> createDispatch(EndpointReference endpointReference,
                                                          javax.xml.bind.JAXBContext context,
                                                          Service.Mode mode,
                                                          WebServiceFeature... features);

    public abstract QName getServiceName();

    public abstract Iterator<QName> getPorts();

    public abstract URL getWSDLDocumentLocation();

    public abstract HandlerResolver getHandlerResolver();

    public abstract void setHandlerResolver(HandlerResolver handlerResolver);

    public abstract Executor getExecutor();

    public abstract void setExecutor(Executor executor);
}


