/**
 * OW2 Specifications
 * Copyright (C) 2008 Bull S.A.S.
 * Contact: easybeans@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: W3CEndpointReference.java 5417 2010-03-24 09:04:14Z benoitf $
 * --------------------------------------------------------------------------
 */

package javax.xml.ws.wsaddressing;

import org.w3c.dom.Element;

import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.annotation.XmlAnyAttribute;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.XmlValue;
import javax.xml.namespace.QName;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.ws.EndpointReference;
import javax.xml.ws.WebServiceException;
import java.util.List;
import java.util.Map;

/**
 * Created by IntelliJ IDEA.
 * User: Guillaume
 * Date: 9 dc. 2008
 * Time: 22:53:57
 * To change this template use File | Settings | File Templates.
 */
@XmlRootElement(name = "EndpointReference", namespace = W3CEndpointReference.NS)
@XmlType(name = "EndpointReferenceType", namespace = W3CEndpointReference.NS)
public final class W3CEndpointReference extends EndpointReference {

    protected static final String NS = "http://www.w3.org/2005/08/addressing";

    private final static JAXBContext context = getJAXBContext();

    protected W3CEndpointReference() {

    }

    public W3CEndpointReference(Source source) {
        try {
            W3CEndpointReference epr = context.createUnmarshaller().unmarshal(source, W3CEndpointReference.class).getValue();
            this.address = epr.address;
            this.metadata = epr.metadata;
            this.referenceParameters = epr.referenceParameters;
        } catch (JAXBException e) {
            throw new WebServiceException("Error unmarshalling W3CEndpointReference ", e);
        } catch (ClassCastException e) {
            throw new WebServiceException("Source did not contain W3CEndpointReference", e);
        }
    }

    public void writeTo(Result result) {
        try {
            Marshaller marshaller = context.createMarshaller();
            marshaller.setProperty(Marshaller.JAXB_FRAGMENT, true);
            marshaller.marshal(this, result);
        } catch (JAXBException e) {
            throw new WebServiceException("Error marshalling W3CEndpointReference. ", e);
        }
    }

    private static JAXBContext getJAXBContext() {
        try {
            return JAXBContext.newInstance(W3CEndpointReference.class);
        } catch (JAXBException e) {
            throw new WebServiceException("Error creating JAXBContext for W3CEndpointReference. ", e);
        }
    }

    @XmlElement(name = "Address", namespace = NS)
    private Address address;

    @XmlElement(name = "ReferenceParameters", namespace = NS)
    private Elements referenceParameters;

    @XmlElement(name = "Metadata", namespace = NS)
    private Elements metadata;

    @XmlAnyAttribute
    Map<QName, String> attributes;

    @XmlAnyElement
    List<Element> elements;

    private static class Address {
        protected Address() {
        }

        @XmlValue
        String uri;

        @XmlAnyAttribute
        Map<QName, String> attributes;
    }


    private static class Elements {
        protected Elements() {
        }

        @XmlAnyElement
        List<Element> elements;
        
        @XmlAnyAttribute
        Map<QName, String> attributes;
    }
}
