/**
 * OW2 Specifications
 * Copyright (C) 2010 Bull S.A.S.
 * Contact: easybeans@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: AssociationOverride.java 6189 2012-03-12 15:20:26Z benoitf $
 * --------------------------------------------------------------------------
 */

package javax.persistence;

import static java.lang.annotation.ElementType.FIELD;
import static java.lang.annotation.ElementType.METHOD;
import static java.lang.annotation.ElementType.TYPE;
import static java.lang.annotation.RetentionPolicy.RUNTIME;

import java.lang.annotation.Retention;
import java.lang.annotation.Target;

/**
 * The AssociationOverride annotation is used to override a many-to-one or
 * one-to-one mapping of property or field for an entity relationship.<br>
 * The AssociationOverride annotation may be applied to an entity that extends a
 * mapped superclass to override a many-to-one or one-to-one mapping defined by
 * the mapped superclass. If the AssociationOverride annotation is not
 * specified, the join column is mapped the same as in the original mapping.
 * @see <a href="http://jcp.org/en/jsr/detail?id=317">JPA 2.0 specification</a>
 * @author Florent Benoit
 * @since JPA 1.0 version.
 */
@Target({ TYPE, METHOD, FIELD })
@Retention(RUNTIME)
public @interface AssociationOverride {

    /**
     * (Required) The name of the relationship property whose mapping is being
     * overridden if property-based access is being used, or the name of the
     * relationship field if field-based access is used.
     */
    String name();

    /**
     * (Required) The join column that is being mapped to the persistent
     * attribute. The mapping type will remain the same as is defined in the
     * mapped superclass.
     */
    JoinColumn[] joinColumns() default {};

    /**
     * The join table that maps the relationship. The join- Table element must be specified if a join table is used in the
     * overriding of the mapping of the relationship. The joinTable element must not be specified if a for- eign key mapping is
     * used in the overriding of the map- ping of the relationship.
     */
    JoinTable joinTable() default @JoinTable;

}
