/**
 * OW2 Specifications
 * Copyright (C) 2010 Bull S.A.S.
 * Contact: easybeans@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: CacheStoreMode.java 5417 2010-03-24 09:04:14Z benoitf $
 * --------------------------------------------------------------------------
 */

package javax.persistence;

/**
 * Used as the value of the javax.persistence.cache.storeMode property to specify the behavior when data is read from the database
 * and when data is committed into the database.
 * @see <a href="http://jcp.org/en/jsr/detail?id=317">JPA 2.0 specification</a>
 * @author Florent Benoit
 * @since JPA 2.0 version.
 */
public enum CacheStoreMode {

    /**
     * Insert/update entity data into cache when read from database and when committed into database: this is the default
     * behavior. Does not force refresh of already cached items when reading from database.
     */
    USE,
    /**
     * Don't insert into cache.
     */
    BYPASS,
    /**
     * Insert/update entity data into cache when read from database and when committed into database. Forces refresh of cache for
     * items read from database.
     */
    REFRESH
}
