/**
 * OW2 Specifications
 * Copyright (C) 2010 Bull S.A.S.
 * Contact: easybeans@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: OneToMany.java 5417 2010-03-24 09:04:14Z benoitf $
 * --------------------------------------------------------------------------
 */

package javax.persistence;

import static java.lang.annotation.ElementType.FIELD;
import static java.lang.annotation.ElementType.METHOD;
import static java.lang.annotation.RetentionPolicy.RUNTIME;
import static javax.persistence.FetchType.LAZY;

import java.lang.annotation.Retention;
import java.lang.annotation.Target;

/**
 * A OneToMany annotation defines a many-valued association with one-to-many
 * multiplicity.
 * @see <a href="http://jcp.org/en/jsr/detail?id=317">JPA 2.0 specification</a>
 * @author Florent Benoit
 * @since JPA 1.0 version.
 */
@Target({ METHOD, FIELD })
@Retention(RUNTIME)
public @interface OneToMany {

    /**
     * (Optional) The entity class that is the target of the association.
     * Optional only if the collection property is defined using Java generics.
     * Must be specified otherwise.
     */
    Class targetEntity() default void.class;

    /**
     * (Optional) The operations that must be cascaded to the target of the
     * association.
     */
    CascadeType[] cascade() default {};

    /**
     * (Optional) Whether the association should be lazily loaded or must be
     * eagerly fetched. The EAGER strategy is a requirement on the persistence
     * provider runtime that the associated entities must be eagerly fetched.
     * The LAZY strategy is a hint to the persistence provider runtime.
     */
    FetchType fetch() default LAZY;

    /**
     * The field that owns the relationship. Required unless the relationship is
     * unidirectional.
     */
    String mappedBy() default "";

    /**
     * (Optional) Whether to apply the remove operation to entities that have been removed from the relationship and to cascade
     * the remove operation to those entities.
     * @since JPA 2.0 version.
     */
    boolean orphanRemoval() default false;
}
