/**
 * OW2 Specifications
 * Copyright (C) 2007 Bull S.A.S.
 * Contact: easybeans@objectweb.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: ListenerRegistration.java 4359 2008-12-10 10:24:40Z sauthieg $
 * --------------------------------------------------------------------------
 */

package javax.management.j2ee;

import java.io.Serializable;
import java.rmi.RemoteException;

import javax.management.InstanceNotFoundException;
import javax.management.ListenerNotFoundException;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
 
/**
 * ListenerRegistration defines the methods which clients of the MEJB use to add and remove event listeners.
 * @author Guillaume Sauthier
 */
public interface ListenerRegistration extends Serializable {

    /**
     * Add a listener to a registered managed object.
     * @param name The name of the managed object on which the
     *        listener should be added.
     * @param listener The listener object which will handle the
     *        notifications emitted by the registered managed object.
     * @param filter The filter object. If filter is null, no
     *        filtering will be performed before handling notifications.
     * @param handback The context to be sent to the listener when
     *        a notification is emitted.
     * @throws InstanceNotFoundException The managed object name
     *         provided does not match any of the registered
     *         managed objects.
     * @throws RemoteException A communication exception occurred
     *         during the execution of a remote method call
     */
    void addNotificationListener(ObjectName name,
                                 NotificationListener listener,
                                 NotificationFilter filter,
                                 Object handback) throws InstanceNotFoundException,
                                                         RemoteException;
    
    /**
     * Remove a listener from a registered managed object.
     * @param name The name of the managed object on which the listener
     *        should be removed.
     * @param listener The listener object which will handle the
     *        notifications emitted by the registered managed object.
     *        This method will remove all the information related
     *        to this listener.
     * @throws InstanceNotFoundException The managed object name provided
     *         does not match any of the registered managed objects.
     * @throws ListenerNotFoundException The listener is not registered
     *         in the managed object.
     * @throws RemoteException A communication exception occurred during
     *         the execution of a remote method call
     */
    void removeNotificationListener(ObjectName name,
                                    NotificationListener listener)
         throws InstanceNotFoundException,
                ListenerNotFoundException,
                RemoteException;
}
