/**
 * OW2 Specifications
 * Copyright (C) 2007 Bull S.A.S.
 * Contact: easybeans@objectweb.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: ManagementHome.java 4359 2008-12-10 10:24:40Z sauthieg $
 * --------------------------------------------------------------------------
 */

package javax.management.j2ee;
 
import java.rmi.RemoteException;

import javax.ejb.CreateException;
import javax.ejb.EJBHome;

/**
 * The required home interface for the Java EE Management EJB
 * component (MEJB). A Java EE client must be able to create a
 * compliant session object using the specified create() method.
 * @author Guillaume Sauthier
 */
public interface ManagementHome extends EJBHome {

    /**
     * Creates an MEJB session object which provides access to
     * the J2EE Management Model.
     * @return An MEJB session object which implements {@link Management}
     * @throws CreateException Indicates a failure to create the EJB object
     * @throws RemoteException A communication exception occurred
     *         during the execution of a remote method call
     */
    Management create()throws CreateException, RemoteException;
}
