/**
 * OW2 Specifications
 * Copyright (C) 2007 Bull S.A.S.
 * Contact: easybeans@objectweb.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: Statistic.java 4359 2008-12-10 10:24:40Z sauthieg $
 * --------------------------------------------------------------------------
 */

package javax.management.j2ee.statistics;

/**
 * The Statistic model and its sub-models specify the data
 * models which are requried to be used to provide the
 * performance data described by the specific attributes
 * in the Stats models.
 * @author Guillaume Sauthier
 */
public interface Statistic {

    /**
     * @return The name of this Statistic.
     */
    String getName();
     
    /**
     * @return The unit of measurement for this Statistic.
     *         Valid values for TimeStatistic measurements
     *         are "HOUR", "MINUTE", "SECOND", "MILLISECOND",
     *         "MICROSECOND" and "NANOSECOND".
     */
    String getUnit();
    
    /**
     * @return A human-readable description of the Statistic.
     */
    String getDescription();
    
    /**
     * @return The time of the first measurement represented as
     *         a long, whose value is the number of milliseconds
     *         since January 1, 1970, 00:00:00.
     */
    long getStartTime();
    
    /**
     * @return The time of the last measurement represented as a
     *         long, whose value is the number of milliseconds
     *         since January 1, 1970, 00:00:00.
     */
    long getLastSampleTime();
}
