/**
 * OW2 Specifications
 * Copyright (C) 2007 Bull S.A.S.
 * Contact: easybeans@objectweb.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: Stats.java 4359 2008-12-10 10:24:40Z sauthieg $
 * --------------------------------------------------------------------------
 */

package javax.management.j2ee.statistics;

/**
 * The Stats model and its submodels specify performance data
 * attributes for each of the specific managed object types.
 * @author Guillaume Sauthier
 */
public interface Stats {
 
    /**
     * Get a Statistic by name.
     * @param statisticName the statistic's name
     * @return the named Statistic
     */
    Statistic getStatistic(String statisticName);
    
    /**
     * Returns an array of Strings which are the names of the
     * attributes from the specific Stats submodel that this
     * object supports. Attributes named in the list must
     * correspond to attributes that will return a Statistic
     * object of the appropriate type which contains valid
     * performance data. The return value of attributes in
     * the Stats submodel that are not included in the
     * statisticNames list must be null. For each name in the
     * statisticNames list there must be one Statistic with
     * the same name in the statistics list.
     * @return the Statistic's names list
     */
    String[] getStatisticNames();
    
    /**
     * Returns an array containing all of the Statistic objects
     * supported by this Stats object.
     * @return an array containing all of the Statistic objects
     *         supported by this Stats object.
     */
    Statistic[] getStatistics();
}
