/**
 * EasyBeans
 * Copyright (C) 2006 Bull S.A.S.
 * Contact: easybeans@objectweb.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: InnerClassMetadata.java 5276 2010-01-08 16:22:04Z benoitf $
 * --------------------------------------------------------------------------
 */

package org.ow2.spec.testengine.metadata;

import org.ow2.spec.testengine.SignatureResultSet;

public class InnerClassMetadata extends AbsMetadata {

    private String name = null;

    private String outerName = null;

    private String innerName = null;

    private int access = 0;

    public InnerClassMetadata(String name, String outerName, String innerName, int access) {
        this.name = name;
        this.outerName = outerName;
        this.innerName = innerName;
        this.access = access;
    }

    @Override
    public String toXML(String indent) {
        StringBuilder sb = new StringBuilder();
        //String newIndent = indent + "  ";

        sb.append("\n");
        sb.append(indent);
        sb.append("<inner-class");

        // attributes

        // Name Attribute
        addObjectToSB("name", name, sb);

        // outerName Attribute
        addObjectToSB("outer-name", outerName, sb);

        // innerName Attribute
        addObjectToSB("inner-name", innerName, sb);

        // access Attribute
        addObjectToSB("access", access, sb);

        sb.append(" />");

        return sb.toString();
    }

    @Override
    public int hashCode() {
        return name.hashCode();
    }

    public String getName() {
        return name;
    }

    public void compare(InnerClassMetadata other, SignatureResultSet rs) {
        // compare access
        compare(getName() + " access", access, other.access, rs);

        // compare name
        compare(getName() + " name", name, other.name, rs);

        // compare outer name
        compare(getName() + " outer Name", outerName, other.outerName, rs);

        // compare inner name
        compare(getName() + " inner name", innerName, other.innerName, rs);

    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof InnerClassMetadata)) {
            return false;
        }

        SignatureResultSet rs = new SignatureResultSet();
        try {
            compare((InnerClassMetadata) o, rs);
        } catch (Exception e) {
            return false;
        }
        return !rs.hasErrors();
    }
}
