/**
 * EasyBeans
 * Copyright (C) 2009 Bull S.A.S.
 * Contact: easybeans@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: Resource.java 5738 2011-02-22 16:42:04Z benoitf $
 * --------------------------------------------------------------------------
 */

package javax.annotation;

import static java.lang.annotation.ElementType.FIELD;
import static java.lang.annotation.ElementType.METHOD;
import static java.lang.annotation.ElementType.TYPE;
import static java.lang.annotation.RetentionPolicy.RUNTIME;

import java.lang.annotation.Retention;
import java.lang.annotation.Target;

/**
 * Used to declare a link to a resource (like a Bean's context, a DataSource, etc).
 * @see <a href="http://jcp.org/en/jsr/detail?id=250">Annotation 1.1 specification</a>
 * @author Florent Benoit
 * @since Annotation 1.0 version.
 */
// seems strange, documented annotation is not used  here ?
@Target({TYPE, FIELD, METHOD})
@Retention(RUNTIME)
public @interface Resource {
    /**
     * Type of the authentication.
     */
   public enum AuthenticationType {
       /**
        * Container.
        */
       CONTAINER,

       /**
        * Application.
        */
       APPLICATION
   }

   /**
    * Name of the resource. (in java:comp ENC environment)
    */
   String name() default "";

   /**
    * Type of the resource.
    */
   Class type() default Object.class;

   /**
    * The authentication type, with container as default.
    */
   AuthenticationType authenticationType() default AuthenticationType.CONTAINER;

   /**
    * Share this resource between components ?
    */
   boolean shareable() default true;

    /**
     * The mappedName element is a product specific name that this resource should be mapped to. The name of this resource, as
     * defined by the name element or defaulted, is a name that is local to the application using the resource. Many application
     * servers provide a way to map these local names to names of resources known to the application server. The mapped name could
     * be of any form. Application servers are not required to support any particular form or type of mapped name, nor the ability
     * to use mapped names. The mapped name is product-dependent and often installation-dependent. No use of mapped name is
     * portable.
     */
   String mappedName() default "";

   /**
    * A description for this resource.
    */
   String description() default "";
   
    /**
     * The lookup element specifies the JNDI name of a resource that the resource being defined will be bound to. The type of the
     * referenced resource must be compatible with that of the resource being defined.
     */
    String lookup() default "";
   
}

