/**
 * OW2 Spec
 * Copyright (C) 2010 Bull S.A.S.
 * Contact: easybeans@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: Provider.java 5374 2010-02-25 17:22:19Z sauthieg $
 * --------------------------------------------------------------------------
 */

package javax.inject;

/**
 * Provides instances of <code>T</code>. Typically implemented by an injector.
 * For any type <code>T</code> that can be injected, you can also inject
 * Provider&lt;T>. Compared to injecting <code>T</code> directly, injecting
 * Provider&lt;T> enables:
 * <ul>
 *  <li>retrieving multiple instances.</li>
 *  <li>lazy or optional retrieval of an instance.</li>
 *  <li>breaking circular dependencies.</li>
 *  <li>abstracting scope so you can look up an instance in a smaller scope from an instance in a containing scope.</li>
 * </ul>
 *
 * For example:
 * <pre>
 *  class Car {
 *    &#064;Inject Car(Provider&lt;Seat> seatProvider) {
 *      Seat driver = seatProvider.get();
 *      Seat passenger = seatProvider.get();
 *      ...
 *    }
 *  }
 * </pre>
 * @author Guillaume Sauthier
 * @since DI 1.0 
 */
public interface Provider<T> {

    /**
     * Provides a fully-constructed and injected instance of <code>T</code>.
     * @throws RuntimeException if the injector encounters an error while providing an instance.
     *         For example, if an injectable member on <code>T</code> throws an exception, the
     *         injector may wrap the exception and throw it to the caller of get(). Callers should
     *         not try to handle such exceptions as the behavior may vary across injector
     *         implementations and even different configurations of the same injector.
     */
    T get();
}
