/**
 * OW2 Spec
 * Copyright (C) 2010 Bull S.A.S.
 * Contact: easybeans@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: Decorator.java 5375 2010-02-25 17:25:09Z sauthieg $
 * --------------------------------------------------------------------------
 */

package javax.decorator;

import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.Target;

import javax.enterprise.inject.Stereotype;

import static java.lang.annotation.ElementType.TYPE;
import static java.lang.annotation.RetentionPolicy.RUNTIME;

/**
 * Specifies that a class is a decorator. May be applied to a managed bean class.
 * <pre>
 *  &#064;Decorator
 *  class TimestampLogger implements Logger { ... }
 * </pre>
 *
 * Decorators of a session bean must comply with the bean provider programming restrictions
 * defined by the EJB specification. Decorators of a stateful session bean must comply with
 * the rules for instance passivation and conversational state defined by the EJB specification.
 *
 * @author Guillaume Sauthier
 *
 * @since CDI 1.0
 *
 */
@Stereotype
@Target(TYPE)
@Retention(RUNTIME)
@Documented
public @interface Decorator {}