/**
 * OW2 Spec
 * Copyright (C) 2010 Bull S.A.S.
 * Contact: easybeans@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: package-info.java 5375 2010-02-25 17:25:09Z sauthieg $
 * --------------------------------------------------------------------------
 */

/**
 * Annotations relating to decorators.
 *
 * A decorator implements one or more bean types and intercepts business method invocations of
 * {@linkplain javax.enterprise.inject.spi.Bean beans} which implement those bean types. These bean
 * types are called decorated types.
 *
 * A decorator is a managed bean annotated {@linkplain javax.decorator.Decorator @Decorator}.
 *
 * Decorators are superficially similar to interceptors, but because they directly implement
 * operations with business semantics, they are able to implement business logic and, conversely,
 * unable to implement the cross-cutting concerns for which interceptors are optimized. Decorators
 * are called after interceptors.
 *
 * <h1>Decorated types</h1>
 *
 * The set of decorated types of a decorator includes all bean types of the managed bean that are
 * Java interfaces, except for {@code Serializable}. The decorator bean class and its super-classes are
 * not decorated types of the decorator. The decorator class may be abstract.
 *
 * A decorator intercepts every method:
 * <ul>
 *  <li>declared by a decorated type of the decorator</li>
 *  <li>that is implemented by the bean class of the decorator.</li>
 * </ul>
 *
 * A decorator may be an abstract class, and is not required to implement every method of every decorated type.
 *
 * <h1>Delegate injection points</h1>
 *
 * All decorators have a {@linkplain javax.decorator.Delegate delegate injection point}. A delegate injection
 * point is an injection point of the bean class annotated {@linkplain javax.decorator.Delegate @Delegate}.
 *
 * The type of the delegate injection point must implement or extend every decorated type. A decorator
 * is not required to implement the type of the delegate injection point.
 *
 * <h1>Enabled decorators</h1>
 *
 * By default, a bean archive has no enabled decorators. A decorator must be explicitly enabled by
 * listing its bean class under the {@code <decorators>} element of the {@code beans.xml} file of the
 * bean archive. The order of the decorator declarations determines the decorator ordering. Decorators
 * which occur earlier in the list are called first.
 *
 * A decorator is bound to a bean if:
 * <ul>
 *  <li>The bean is {@linkplain javax.enterprise.inject eligible for injection} to the delegate
 *      injection point of the decorator.</li>
 *  <li>The decorator is enabled in the bean archive of the bean.</li>
 * </ul>
 *
 * If a managed bean class is declared final, it may not have decorators. If a managed bean has a
 * non-static, non-private, final method, it may not have any decorator which implements that method.
 *
 * A decorator instance is a {@linkplain javax.enterprise.context.Dependent dependent object} of the
 * object it decorates.
 * 
 * @see javax.enterprise.inject
 * @see javax.decorator.Decorator
 * @see javax.decorator.Delegate
 */
package javax.decorator;