/**
 * OW2 Spec
 * Copyright (C) 2010 Bull S.A.S.
 * Contact: easybeans@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: ConversationScoped.java 5735 2011-02-21 16:48:42Z sauthieg $
 * --------------------------------------------------------------------------
 */

package javax.enterprise.context;

import java.lang.annotation.Documented;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.Target;

import static java.lang.annotation.ElementType.FIELD;
import static java.lang.annotation.ElementType.METHOD;
import static java.lang.annotation.ElementType.TYPE;
import static java.lang.annotation.RetentionPolicy.RUNTIME;

/**
 * Specifies that a bean is conversation scoped.
 *
 * The conversation scope is active:
 * <ul>
 *  <li>during all standard life-cycle phases of any JSF faces or non-faces request.</li>
 * </ul>
 *
 * The conversation context provides access to state associated with a particular
 * conversation. Every JSF request has an associated conversation. This association
 * is managed automatically by the container according to the following rules:
 * <ul>
 *  <li>Any JSF request has exactly one associated conversation.</li>
 *  <li>The conversation associated with a JSF request is determined at the beginning of the
 *      restore view phase and does not change during the request.</li>
 * </ul>
 *
 * Any conversation is in one of two states: transient or long-running.
 * <ul>
 *  <li>By default, a conversation is transient</li>
 *  <li>A transient conversation may be marked long-running by calling {@link Conversation#begin()}</li>
 *  <li>A long-running conversation may be marked transient by calling {@link Conversation#end()}</li>
 * </ul>
 *
 * All long-running conversations have a string-valued unique identifier, which may be
 * set by the application when the conversation is marked long-running, or generated by the container.
 *
 * If the conversation associated with the current JSF request is in the transient state at the
 * end of a JSF request, it is destroyed, and the conversation context is also destroyed.
 *
 * If the conversation associated with the current JSF request is in the long-running state at
 * the end of a JSF request, it is not destroyed. Instead, it may be propagated to other requests
 * according to the following rules:
 * <ul>
 *  <li>The long-running conversation context associated with a request that renders a JSF view
 *      is automatically propagated to any faces request (JSF form submission) that originates
 *      from that rendered page.</li>
 *  <li>The long-running conversation context associated with a request that results in a JSF
 *      redirect (a redirect resulting from a navigation rule or JSF NavigationHandler) is
 *      automatically propagated to the resulting non-faces request, and to any other subsequent
 *      request to the same URL. This is accomplished via use of a GET request parameter named
 *      {@code cid} containing the unique identifier of the conversation.</li>
 *  <li>The long-running conversation associated with a request may be propagated to any
 *      non-faces request via use of a GET request parameter named cid containing the unique
 *      identifier of the conversation. In this case, the application must manage this request
 *      parameter.</li>
 * </ul>
 *
 * When no conversation is propagated to a JSF request, the request is associated with a new
 * transient conversation. All long-running conversations are scoped to a particular HTTP servlet
 * session and may not cross session boundaries. In the following cases, a propagated long-running
 * conversation cannot be restored and re-associated with the request:
 * <ul>
 *  <li>When the HTTP servlet session is invalidated, all long-running conversation contexts created
 *      during the current session are destroyed, after the servlet {@code service()} method completes.</li>
 *  <li>The container is permitted to arbitrarily destroy any long-running conversation that
 *      is associated with no current JSF request, in order to conserve resources.</li>
 * </ul>
 *
 * @author Guillaume Sauthier
 * @since CDI 1.0
 */
@Target({TYPE, METHOD, FIELD})
@Retention(RUNTIME)
@Documented
@Inherited
@NormalScope(passivating = true)
public @interface ConversationScoped {}