/**
 * OW2 Spec
 * Copyright (C) 2010 Bull S.A.S.
 * Contact: easybeans@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: package-info.java 5375 2010-02-25 17:25:09Z sauthieg $
 * --------------------------------------------------------------------------
 */

/**
 * Annotations and interfaces relating to scopes and contexts.
 *
 * A scope type is a Java annotation annotated {@code @Scope} or {@linkplain javax.enterprise.context.NormalScope @NormalScope}.
 * The scope of a bean determines the life-cycle and visibility of its instances. In particular,
 * the scope determines:
 * <ul>
 *  <li>When a new instance of the bean is created</li>
 *  <li>When an existing instance of the bean is destroyed</li>
 *  <li>Which injected references refer to any instance of the bean</li>
 * </ul>
 *
 * <h1>Built-in scopes</h1>
 *
 * The following built-in scopes are provided: {@linkplain javax.enterprise.context.Dependent @Dependent},
 * {@linkplain javax.enterprise.context.RequestScoped @RequestScoped}, {@linkplain javax.enterprise.context.ConversationScoped @ConversationScoped},
 * {@linkplain javax.enterprise.context.SessionScoped @SessionScoped}, {@linkplain javax.enterprise.context.ApplicationScoped @ApplicationScoped},
 * {@code @Singleton}.
 *
 * The container provides an implementation of the {@link javax.enterprise.context.spi.Context} interface for
 * each of the built-in scopes. The built-in request, session, and application contexts support servlet,
 * web service and EJB invocations. The built-in conversation context supports JSF requests.
 *
 * For other kinds of invocations, a portable extension may define a custom {@linkplain javax.enterprise.context.spi.Context context object}
 * for any or all of the built-in scopes. For example, a third-party web application framework might
 * provide a conversation context object for the built-in conversation scope.
 *
 * The context associated with a built-in scope propagates across local, synchronous Java method calls,
 * including invocation of EJB local business methods. The context does not propagate across remote
 * method invocations or to asynchronous processes such as JMS message listeners or EJB timer service timeouts.
 *
 * <h1>Normal scopes and pseudo-scopes</h1>
 *
 * Most scopes are <i>normal scopes</i>. Normal scopes are declared using {@linkplain javax.enterprise.context.NormalScope @NormalScope}.
 * If a bean has a normal scope, every client executing in a certain thread sees the same contextual instance
 * of the bean. This instance is called the <i>current instance</i> of the bean. The operation
 * {@link javax.enterprise.context.spi.Context#get(Contextual)} of the context object for a normal scope type
 * always returns the current instance of the given bean.
 *
 * Any scope that is not a normal scope is called a pseudo-scope. Pseudo-scopes are declared using
 * {@code @Scope}. The concept of a current instance is not well-defined in the case of a <i>pseudo-scope</i>.
 * Different clients executing in the same thread may see different instances of the bean. In the extreme
 * case of the {@linkplain javax.enterprise.context.Dependent @Dependent} pseudo-scope, every client has its own private instance of the bean.
 *
 * All built-in scopes are normal scopes, except for the {@linkplain javax.enterprise.context.Dependent @Dependent} and
 * {@code @Singleton} pseudo-scopes.
 *
 * <h1>Contextual and injected reference validity</h1>
 *
 * A reference to a bean obtained from the container via {@linkplain javax.enterprise.inject.Instance programmatic lookup}
 * is called a contextual reference. A contextual reference for a bean with a normal scope refers to the
 * current instance of the bean. A contextual reference for a bean are valid only for a certain period of
 * time. The application should not invoke a method of an invalid reference.
 *
 * The validity of a contextual reference for a bean depends upon whether the scope of the bean is a
 * normal scope or a pseudo-scope:
 * <ul>
 *  <li>Any reference to a bean with a normal scope is valid as long as the application maintains a hard
 *      reference to it. However, it may only be invoked when the context associated with the normal scope
 *      is active. If it is invoked when the context is inactive, a {@link javax.enterprise.context.ContextNotActiveException} is
 *      thrown by the container.</li>
 *  <li>Any reference to a bean with a pseudo-scope is valid until the bean instance to which it refers is
 *      destroyed. It may be invoked even if the context associated with the pseudo-scope is not active.
 *      If the application invokes a method of a reference to an instance that has already been destroyed,
 *      the behavior is undefined.</li>
 * </ul>
 *
 * A reference to a bean obtained from the container via dependency injection is a special kind of
 * contextual reference, called an injected reference. Additional restrictions apply to the validity
 * of an injected reference:
 * <ul>
 *  <li>A reference to a bean injected into a field, bean constructor or initializer method is only
 *      valid until the object into which it was injected is destroyed.</li>
 *  <li>A reference to a bean injected into a producer method is only valid until the producer method
 *      bean instance that is being produced is destroyed.</li>
 *  <li>A reference to a bean injected into a disposer method or observer method is only valid until
 *      the invocation of the method completes.</li>
 * </ul>
 *
 * @see javax.enterprise.inject
 */
package javax.enterprise.context;