/**
 * OW2 Spec
 * Copyright (C) 2010 Bull S.A.S.
 * Contact: easybeans@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: Reception.java 5375 2010-02-25 17:25:09Z sauthieg $
 * --------------------------------------------------------------------------
 */

package javax.enterprise.event;

/**
 * Distinguishes conditional observer methods from observer methods which are always notified.
 *
 * A conditional observer method is an observer method which is notified of an event only
 * if an instance of the bean that defines the observer method already exists in the
 * current context.
 *
 * Beans with scope @{@link javax.enterprise.context.Dependent} may not have conditional
 * observer methods.
 *
 * @author Guillaume Sauthier
 */
public enum Reception {

    /**
     * Specifies that an observer method always receives event notifications.
     */
    ALWAYS,

    /**
     * Specifies that an observer method is only called if the current instance of
     * the bean declaring the observer method already exists.
     */
    IF_EXISTS
}
